/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download.http_downloader;

import android.text.TextUtils;

public class ContentRangeInfo {
    public final String contentType;
    public final long startPos;
    public final long endPos;
    public final long totalLength;

    private ContentRangeInfo(String contentType, long startPos, long endPos, long totalLength) {
        this.contentType = contentType;
        this.startPos = startPos;
        this.endPos = endPos;
        this.totalLength = totalLength;
    }

    public static ContentRangeInfo getContentRangeInfo(String contentRangeStr) {
        String[] contentRangeStrArrayTemp;
        ContentRangeInfo contentRangeInfo = null;
        String contentType = null;
        String rangeStartPos = null;
        String rangeEndPos = null;
        String totalLength = null;
        if (!TextUtils.isEmpty((CharSequence)contentRangeStr) && (contentRangeStrArrayTemp = contentRangeStr.split(" ")) != null && contentRangeStrArrayTemp.length >= 2) {
            String[] contentRangeAndLengthArrayTemp;
            contentType = contentRangeStrArrayTemp[0];
            String contentRangeAndLength = contentRangeStrArrayTemp[1];
            if (!TextUtils.isEmpty((CharSequence)contentRangeAndLength) && (contentRangeAndLengthArrayTemp = contentRangeAndLength.split("/")) != null && contentRangeAndLengthArrayTemp.length >= 2) {
                String contentRanges = contentRangeAndLengthArrayTemp[0];
                String[] contentRangesArrayTemp = contentRanges.split("-");
                if (contentRangesArrayTemp != null && contentRangesArrayTemp.length >= 2) {
                    rangeStartPos = contentRangesArrayTemp[0];
                    rangeEndPos = contentRangesArrayTemp[1];
                }
                totalLength = contentRangeAndLengthArrayTemp[1];
            }
        }
        if (!(TextUtils.isEmpty(contentType) || TextUtils.isEmpty(rangeStartPos) || TextUtils.isEmpty(rangeEndPos) || TextUtils.isEmpty(totalLength))) {
            try {
                long startPos = Long.parseLong(rangeStartPos);
                long endPos = Long.parseLong(rangeEndPos);
                long totalLen = Long.parseLong(totalLength);
                contentRangeInfo = new ContentRangeInfo(contentType.trim(), startPos, endPos + 1L, totalLen);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return contentRangeInfo;
    }
}

