/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download.db_recorder;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.db.BaseContentDbDao;

public class DownloadFileDao
extends BaseContentDbDao {
    private static final String TAG = DownloadFileDao.class.getSimpleName();

    public DownloadFileDao(SQLiteOpenHelper dbHelper) {
        super(dbHelper, "tb_download_file", "_id");
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(DownloadFileInfo.Table.getCreateTableSql());
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(TAG, TAG + ".onUpgrade\uff0coldVersion\uff1a" + oldVersion + "\uff0coldVersion\uff1a" + newVersion);
        if (newVersion == 2) {
            switch (oldVersion) {
                case 1: {
                    this.updateVersion1To2(db);
                }
            }
        } else if (newVersion == 3) {
            switch (oldVersion) {
                case 1: {
                    this.updateVersion1To3(db);
                    break;
                }
                case 2: {
                    this.updateVersion2To3(db);
                }
            }
        }
    }

    private void updateVersion1To2(SQLiteDatabase db) {
        db.execSQL(DownloadFileInfo.Table.getUpdateTableVersion1To2Sql());
    }

    private void updateVersion2To3(SQLiteDatabase db) {
        db.execSQL(DownloadFileInfo.Table.getUpdateTableVersion2To3Sql());
    }

    private void updateVersion1To3(SQLiteDatabase db) {
        db.execSQL(DownloadFileInfo.Table.getUpdateTableVersion1To2Sql());
        db.execSQL(DownloadFileInfo.Table.getUpdateTableVersion2To3Sql());
    }
}

