/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.base;

import android.text.TextUtils;

public abstract class FailReason
extends Exception {
    public static final String TYPE_UNKNOWN = FailReason.class.getName() + "_TYPE_UNKNOWN";
    public static final String TYPE_NULL_POINTER = FailReason.class.getName() + "_TYPE_NULL_POINTER";
    private String mType = TYPE_UNKNOWN;

    public FailReason(String type) {
        this.mType = type;
        if (!this.isTypeInit()) {
            this.initType(this);
        }
    }

    public FailReason(String detailMessage, String type) {
        super(detailMessage);
        this.mType = type;
        if (!this.isTypeInit()) {
            this.initType(this);
        }
    }

    public FailReason(String detailMessage, Throwable throwable, String type) {
        super(detailMessage, throwable);
        this.mType = type;
        if (!this.isTypeInit()) {
            this.initType(throwable);
        }
    }

    public FailReason(Throwable throwable, String type) {
        super(throwable);
        this.mType = type;
        if (!this.isTypeInit()) {
            this.initType(throwable);
        }
    }

    public FailReason(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.initType(throwable);
    }

    public FailReason(Throwable throwable) {
        super(throwable);
        this.initType(throwable);
    }

    protected final boolean isTypeInit() {
        return !TYPE_UNKNOWN.equals(this.mType) && !TextUtils.isEmpty((CharSequence)this.mType);
    }

    private void initType(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.onInitTypeWithThrowable(throwable);
        if (throwable == throwable.getCause()) {
            return;
        }
        if (!this.isTypeInit()) {
            this.initType(throwable.getCause());
        }
    }

    protected void onInitTypeWithThrowable(Throwable throwable) {
        if (this.isTypeInit() || throwable == null) {
            return;
        }
        if (throwable instanceof FailReason) {
            FailReason failReason = (FailReason)throwable;
            this.onInitTypeWithOriginalThrowable(failReason.getOriginalCause());
            if (this.isTypeInit()) {
                return;
            }
            this.onInitTypeWithFailReasonInternal(failReason);
        } else {
            this.onInitTypeWithOriginalThrowable(throwable);
        }
    }

    private void onInitTypeWithFailReasonInternal(FailReason failReason) {
        Throwable cause;
        if (failReason == null) {
            return;
        }
        this.onInitTypeWithFailReason(failReason);
        if (!this.isTypeInit() && (cause = failReason.getCause()) instanceof FailReason) {
            this.onInitTypeWithFailReasonInternal((FailReason)cause);
        }
    }

    protected void onInitTypeWithFailReason(FailReason failReason) {
    }

    protected void onInitTypeWithOriginalThrowable(Throwable originalThrowable) {
        if (originalThrowable == null) {
            return;
        }
        String throwableClassName = originalThrowable.getClass().getName();
        if (TextUtils.isEmpty((CharSequence)throwableClassName)) {
            return;
        }
        if (throwableClassName.equals(NullPointerException.class.getName())) {
            this.mType = TYPE_NULL_POINTER;
        }
    }

    protected final void setType(String type) {
        this.mType = type;
    }

    public String getType() {
        return this.mType;
    }

    public Throwable getOriginalCause() {
        return this.getOriginalCauseInternal(this);
    }

    private Throwable getOriginalCauseInternal(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = throwable.getCause();
        if (cause instanceof FailReason) {
            return this.getOriginalCauseInternal(cause);
        }
        return cause;
    }
}

