/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import java.io.File;
import java.util.Date;
import org.wlf.filedownloader.base.BaseUrlFileInfo;
import org.wlf.filedownloader.file_download.DetectUrlFileInfo;
import org.wlf.filedownloader.util.DateUtil;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadFileInfo
extends BaseUrlFileInfo {
    private static final String TEMP_FILE_SUFFIX = "temp";
    private Integer mId;
    private long mDownloadedSize;
    private String mTempFileName;
    private int mStatus = 0;

    private DownloadFileInfo() {
    }

    DownloadFileInfo(DetectUrlFileInfo detectUrlFileInfo) {
        this.mUrl = detectUrlFileInfo.getUrl();
        this.mFileName = detectUrlFileInfo.getFileName();
        this.mFileSize = detectUrlFileInfo.getFileSizeLong();
        this.mETag = detectUrlFileInfo.getETag();
        this.mLastModified = detectUrlFileInfo.getLastModified();
        this.mAcceptRangeType = detectUrlFileInfo.getAcceptRangeType();
        this.mFileDir = detectUrlFileInfo.getFileDir();
        this.mTempFileName = this.mFileName + "." + TEMP_FILE_SUFFIX;
        this.mCreateDatetime = DateUtil.date2String_yyyy_MM_dd_HH_mm_ss(new Date());
    }

    DownloadFileInfo(Cursor cursor) {
        String createDatetime;
        int status;
        String fileName;
        String tempFileName;
        String fileDir;
        String acceptRangeType;
        String lastModified;
        String eTag;
        long fileSize;
        long downloadedSize;
        String url;
        int id;
        if (cursor != null && !cursor.isClosed()) {
            id = -1;
            url = null;
            downloadedSize = 0L;
            fileSize = 0L;
            eTag = null;
            lastModified = null;
            acceptRangeType = null;
            fileDir = null;
            tempFileName = null;
            fileName = null;
            status = 0;
            createDatetime = null;
            int columnIndex = -1;
            columnIndex = cursor.getColumnIndex("_id");
            if (columnIndex != -1) {
                id = cursor.getInt(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("url")) != -1) {
                url = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("downloaded_size")) != -1) {
                downloadedSize = cursor.getLong(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("file_size")) != -1) {
                fileSize = cursor.getLong(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("e_tag")) != -1) {
                eTag = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("last_modified")) != -1) {
                lastModified = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("accept_range_type")) != -1) {
                acceptRangeType = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("file_dir")) != -1) {
                fileDir = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("temp_file_name")) != -1) {
                tempFileName = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("file_name")) != -1) {
                fileName = cursor.getString(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("status")) != -1) {
                status = cursor.getInt(columnIndex);
            }
            if ((columnIndex = cursor.getColumnIndex("create_datetime")) != -1) {
                createDatetime = cursor.getString(columnIndex);
            }
            if (id <= 0 || TextUtils.isEmpty((CharSequence)url)) {
                throw new IllegalArgumentException("id and url from cursor illegal!");
            }
        } else {
            throw new NullPointerException("cursor illegal!");
        }
        this.mId = id;
        this.mUrl = url;
        this.mDownloadedSize = downloadedSize;
        this.mFileSize = fileSize;
        this.mETag = eTag;
        this.mLastModified = lastModified;
        this.mAcceptRangeType = acceptRangeType;
        this.mFileDir = fileDir;
        this.mTempFileName = tempFileName;
        this.mFileName = fileName;
        this.mStatus = status;
        this.mCreateDatetime = createDatetime;
    }

    void update(DownloadFileInfo downloadFileInfo) {
        if (downloadFileInfo.mId != null && downloadFileInfo.mId > 0) {
            this.mId = downloadFileInfo.mId;
        }
        if (UrlUtil.isUrl(downloadFileInfo.mUrl)) {
            this.mUrl = downloadFileInfo.mUrl;
        }
        if (downloadFileInfo.mDownloadedSize > 0L && downloadFileInfo.mDownloadedSize != this.mDownloadedSize) {
            this.mDownloadedSize = downloadFileInfo.mDownloadedSize;
        }
        if (downloadFileInfo.mFileSize > 0L && downloadFileInfo.mFileSize != this.mFileSize) {
            this.mFileSize = downloadFileInfo.mFileSize;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mETag)) {
            this.mETag = downloadFileInfo.mETag;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mLastModified)) {
            this.mLastModified = downloadFileInfo.mLastModified;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mAcceptRangeType)) {
            this.mAcceptRangeType = downloadFileInfo.mAcceptRangeType;
        }
        if (FileUtil.isFilePath(downloadFileInfo.mFileDir)) {
            this.mFileDir = downloadFileInfo.mFileDir;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mTempFileName)) {
            this.mTempFileName = downloadFileInfo.mTempFileName;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mFileName)) {
            this.mFileName = downloadFileInfo.mFileName;
        }
        if (downloadFileInfo.mStatus != this.mStatus) {
            this.mStatus = downloadFileInfo.mStatus;
        }
        if (!TextUtils.isEmpty((CharSequence)downloadFileInfo.mCreateDatetime)) {
            this.mCreateDatetime = downloadFileInfo.mCreateDatetime;
        }
    }

    ContentValues getContentValues() {
        ContentValues values = new ContentValues();
        values.put("url", this.mUrl);
        values.put("downloaded_size", Long.valueOf(this.mDownloadedSize));
        values.put("file_size", Long.valueOf(this.mFileSize));
        values.put("e_tag", this.mETag);
        values.put("last_modified", this.mLastModified);
        values.put("accept_range_type", this.mAcceptRangeType);
        values.put("file_dir", this.mFileDir);
        values.put("temp_file_name", this.mTempFileName);
        values.put("file_name", this.mFileName);
        values.put("status", Integer.valueOf(this.mStatus));
        values.put("create_datetime", this.mCreateDatetime);
        return values;
    }

    public boolean equals(Object o) {
        if (!TextUtils.isEmpty((CharSequence)this.mUrl) && o instanceof DownloadFileInfo) {
            DownloadFileInfo other = (DownloadFileInfo)o;
            return this.mUrl.equals(other.mUrl);
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            return this.mUrl.hashCode();
        }
        return super.hashCode();
    }

    void setId(Integer id) {
        this.mId = id;
    }

    void setDownloadedSize(long downloadedSize) {
        this.mDownloadedSize = downloadedSize;
    }

    void setStatus(int status) {
        this.mStatus = status;
    }

    void setFileDir(String fileDir) {
        this.mFileDir = fileDir;
    }

    void setFileName(String fileName) {
        this.mFileName = fileName;
    }

    public Integer getId() {
        return this.mId;
    }

    @Deprecated
    public int getDownloadedSize() {
        return (int)this.mDownloadedSize;
    }

    public long getDownloadedSizeLong() {
        return this.mDownloadedSize;
    }

    public String getTempFileName() {
        return this.mTempFileName;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public String getTempFilePath() {
        return this.getFileDir() + File.separator + this.mTempFileName;
    }

    public static final class Table {
        public static final String TABLE_NAME_OF_DOWNLOAD_FILE = "tb_download_file";
        public static final String COLUMN_NAME_OF_FIELD_ID = "_id";
        public static final String COLUMN_NAME_OF_FIELD_URL = "url";
        public static final String COLUMN_NAME_OF_FIELD_DOWNLOADED_SIZE = "downloaded_size";
        public static final String COLUMN_NAME_OF_FIELD_FILE_SIZE = "file_size";
        public static final String COLUMN_NAME_OF_FIELD_E_TAG = "e_tag";
        public static final String COLUMN_NAME_OF_FIELD_LAST_MODIFIED = "last_modified";
        public static final String COLUMN_NAME_OF_FIELD_ACCEPT_RANGE_TYPE = "accept_range_type";
        public static final String COLUMN_NAME_OF_FIELD_FILE_DIR = "file_dir";
        public static final String COLUMN_NAME_OF_FIELD_TEMP_FILE_NAME = "temp_file_name";
        public static final String COLUMN_NAME_OF_FIELD_FILE_NAME = "file_name";
        public static final String COLUMN_NAME_OF_FIELD_STATUS = "status";
        public static final String COLUMN_NAME_OF_FIELD_CREATE_DATETIME = "create_datetime";

        public static final String getCreateTableSql() {
            String createTableSql = "CREATE TABLE IF NOT EXISTS tb_download_file(_id INTEGER PRIMARY KEY AUTOINCREMENT,url TEXT UNIQUE,downloaded_size INTEGER,file_size INTEGER,e_tag TEXT,last_modified TEXT,accept_range_type TEXT,file_dir TEXT,temp_file_name TEXT,file_name TEXT,status INTEGER,create_datetime TEXT)";
            return createTableSql;
        }

        public static final String getUpdateTableVersion1To2Sql() {
            String updateSql = "ALTER TABLE tb_download_file ADD create_datetime TEXT";
            return updateSql;
        }

        public static final String getUpdateTableVersion2To3Sql() {
            String updateSql = "ALTER TABLE tb_download_file ADD last_modified TEXT";
            return updateSql;
        }
    }
}

