/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;

public interface OnDownloadFileChangeListener {
    public void onDownloadFileCreated(DownloadFileInfo var1);

    public void onDownloadFileUpdated(DownloadFileInfo var1, Type var2);

    public void onDownloadFileDeleted(DownloadFileInfo var1);

    public static enum Type {
        DOWNLOAD_STATUS,
        DOWNLOADED_SIZE,
        SAVE_DIR,
        SAVE_FILE_NAME,
        OTHER;

    }

    public static class MainThreadHelper {
        public static void onDownloadFileCreated(final DownloadFileInfo downloadFileInfo, final OnDownloadFileChangeListener onDownloadFileChangeListener) {
            if (onDownloadFileChangeListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDownloadFileChangeListener == null) {
                        return;
                    }
                    onDownloadFileChangeListener.onDownloadFileCreated(downloadFileInfo);
                }
            });
        }

        public static void onDownloadFileUpdated(final DownloadFileInfo downloadFileInfo, final Type type, final OnDownloadFileChangeListener onDownloadFileChangeListener) {
            if (onDownloadFileChangeListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDownloadFileChangeListener == null) {
                        return;
                    }
                    onDownloadFileChangeListener.onDownloadFileUpdated(downloadFileInfo, type);
                }
            });
        }

        public static void onDownloadFileDeleted(final DownloadFileInfo downloadFileInfo, final OnDownloadFileChangeListener onDownloadFileChangeListener) {
            if (onDownloadFileChangeListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onDownloadFileChangeListener == null) {
                        return;
                    }
                    onDownloadFileChangeListener.onDownloadFileDeleted(downloadFileInfo);
                }
            });
        }
    }
}

