/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_rename;

import android.text.TextUtils;
import java.io.File;
import java.util.List;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_rename.DownloadFileRenamer;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;

class RenameDownloadFileTask
implements Runnable {
    private static final String TAG = RenameDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private String mNewFileName;
    private boolean includedSuffix;
    private DownloadFileRenamer mDownloadFileRenamer;
    private OnRenameDownloadFileListener mOnRenameDownloadFileListener;

    public RenameDownloadFileTask(String url, String newFileName, boolean includedSuffix, DownloadFileRenamer downloadFileRenamer) {
        this.mUrl = url;
        this.mNewFileName = newFileName;
        this.includedSuffix = includedSuffix;
        this.mDownloadFileRenamer = downloadFileRenamer;
    }

    public void setOnRenameDownloadFileListener(OnRenameDownloadFileListener onRenameDownloadFileListener) {
        this.mOnRenameDownloadFileListener = onRenameDownloadFileListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OnRenameDownloadFileListener.OnRenameDownloadFileFailReason failReason;
        DownloadFileInfo downloadFileInfo;
        block34: {
            block43: {
                block35: {
                    boolean renameResult;
                    File newFile;
                    String oldFileName;
                    String dirPath;
                    block32: {
                        block42: {
                            block33: {
                                block30: {
                                    block41: {
                                        block31: {
                                            block28: {
                                                block40: {
                                                    block29: {
                                                        int index;
                                                        block26: {
                                                            block39: {
                                                                block27: {
                                                                    block24: {
                                                                        block38: {
                                                                            block25: {
                                                                                downloadFileInfo = null;
                                                                                failReason = null;
                                                                                downloadFileInfo = this.mDownloadFileRenamer.getDownloadFile(this.mUrl);
                                                                                if (DownloadFileUtil.isLegal(downloadFileInfo)) break block24;
                                                                                failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the download file is not exist !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST);
                                                                                if (failReason != null) break block25;
                                                                                this.notifySuccess(downloadFileInfo);
                                                                                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                                                break block38;
                                                                            }
                                                                            this.notifyFailed(downloadFileInfo, failReason);
                                                                            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                                        }
                                                                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                                        return;
                                                                    }
                                                                    this.notifyPrepared(downloadFileInfo);
                                                                    if (DownloadFileUtil.canRename(downloadFileInfo)) break block26;
                                                                    failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the download file status error !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_STATUS_ERROR);
                                                                    if (failReason != null) break block27;
                                                                    this.notifySuccess(downloadFileInfo);
                                                                    Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                                    break block39;
                                                                }
                                                                this.notifyFailed(downloadFileInfo, failReason);
                                                                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                            }
                                                            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                            return;
                                                        }
                                                        dirPath = downloadFileInfo.getFileDir();
                                                        oldFileName = downloadFileInfo.getFileName();
                                                        String suffix = "";
                                                        if (oldFileName != null && oldFileName.contains(".") && (index = oldFileName.lastIndexOf(".")) != -1) {
                                                            suffix = oldFileName.substring(index, oldFileName.length());
                                                        }
                                                        if (!this.includedSuffix) {
                                                            this.mNewFileName = this.mNewFileName + suffix;
                                                        }
                                                        newFile = new File(dirPath, this.mNewFileName);
                                                        if (!TextUtils.isEmpty((CharSequence)this.mNewFileName)) break block28;
                                                        failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("new file name is empty !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_NEW_FILE_NAME_IS_EMPTY);
                                                        if (failReason != null) break block29;
                                                        this.notifySuccess(downloadFileInfo);
                                                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                        break block40;
                                                    }
                                                    this.notifyFailed(downloadFileInfo, failReason);
                                                    Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                }
                                                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                return;
                                            }
                                            if (!this.checkNewFileExist(newFile)) break block30;
                                            failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the new file has been exist !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_NEW_FILE_HAS_BEEN_EXIST);
                                            if (failReason != null) break block31;
                                            this.notifySuccess(downloadFileInfo);
                                            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                            break block41;
                                        }
                                        this.notifyFailed(downloadFileInfo, failReason);
                                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                    }
                                    Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                    return;
                                }
                                renameResult = false;
                                try {
                                    this.mDownloadFileRenamer.renameDownloadFile(downloadFileInfo.getUrl(), this.mNewFileName);
                                    renameResult = true;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (renameResult) break block32;
                                failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("rename file in db failed !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_UNKNOWN);
                                if (failReason != null) break block33;
                                this.notifySuccess(downloadFileInfo);
                                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                break block42;
                            }
                            this.notifyFailed(downloadFileInfo, failReason);
                            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                        }
                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                        return;
                    }
                    try {
                        if (!DownloadFileUtil.isCompleted(downloadFileInfo)) break block34;
                        File oldSaveFile = new File(dirPath, oldFileName);
                        if (oldSaveFile.exists()) {
                            renameResult = oldSaveFile.renameTo(newFile);
                        } else {
                            renameResult = false;
                            failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the original file not exist !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST);
                        }
                        if (renameResult) break block34;
                        try {
                            this.mDownloadFileRenamer.renameDownloadFile(downloadFileInfo.getUrl(), oldFileName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                this.mDownloadFileRenamer.renameDownloadFile(downloadFileInfo.getUrl(), oldFileName);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (failReason == null) {
                            failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("rename file in file system failed !", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_UNKNOWN);
                        }
                        if (failReason != null) break block35;
                        this.notifySuccess(downloadFileInfo);
                    }
                    catch (Exception e) {
                        block44: {
                            block36: {
                                try {
                                    e.printStackTrace();
                                    failReason = new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason(e);
                                    if (failReason != null) break block36;
                                    this.notifySuccess(downloadFileInfo);
                                }
                                catch (Throwable throwable) {
                                    if (failReason == null) {
                                        this.notifySuccess(downloadFileInfo);
                                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                    } else {
                                        this.notifyFailed(downloadFileInfo, failReason);
                                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                    }
                                    Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                    throw throwable;
                                }
                                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                break block44;
                            }
                            this.notifyFailed(downloadFileInfo, failReason);
                            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                        }
                        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                    }
                    Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                    break block43;
                }
                this.notifyFailed(downloadFileInfo, failReason);
                Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
            }
            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
            return;
        }
        if (failReason == null) {
            this.notifySuccess(downloadFileInfo);
            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u6210\u529f\uff0curl\uff1a" + this.mUrl);
        } else {
            this.notifyFailed(downloadFileInfo, failReason);
            Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
        }
        Log.d(TAG, TAG + ".run \u91cd\u547d\u540d\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
    }

    private boolean checkNewFileExist(File newFile) {
        if (newFile != null && newFile.exists()) {
            return true;
        }
        List<DownloadFileInfo> downloadFileInfos = this.mDownloadFileRenamer.getDownloadFiles();
        if (!CollectionUtil.isEmpty(downloadFileInfos)) {
            for (DownloadFileInfo info : downloadFileInfos) {
                String path;
                if (info == null || TextUtils.isEmpty((CharSequence)(path = info.getFilePath())) || !path.equals(newFile.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    private void notifyPrepared(DownloadFileInfo downloadFileInfo) {
        if (this.mOnRenameDownloadFileListener == null) {
            return;
        }
        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFilePrepared(downloadFileInfo, this.mOnRenameDownloadFileListener);
    }

    private void notifySuccess(DownloadFileInfo downloadFileInfo) {
        if (this.mOnRenameDownloadFileListener == null) {
            return;
        }
        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileSuccess(downloadFileInfo, this.mOnRenameDownloadFileListener);
    }

    private void notifyFailed(DownloadFileInfo downloadFileInfo, OnRenameDownloadFileListener.RenameDownloadFileFailReason failReason) {
        if (this.mOnRenameDownloadFileListener == null) {
            return;
        }
        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, failReason, this.mOnRenameDownloadFileListener);
    }
}

