/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download.http_downloader;

import android.text.TextUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.base.FailReason;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.CloseConnectionTask;
import org.wlf.filedownloader.file_download.HttpConnectionHelper;
import org.wlf.filedownloader.file_download.base.HttpFailReason;
import org.wlf.filedownloader.file_download.file_saver.FileSaver;
import org.wlf.filedownloader.file_download.http_downloader.ContentLengthInputStream;
import org.wlf.filedownloader.file_download.http_downloader.ContentRangeInfo;
import org.wlf.filedownloader.file_download.http_downloader.Download;
import org.wlf.filedownloader.file_download.http_downloader.Range;

public class HttpDownloader
implements Download {
    private static final String TAG = HttpDownloader.class.getSimpleName();
    private static final int MAX_REDIRECT_TIMES = 5;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String mUrl;
    private Range mRange;
    private String mAcceptRangeType;
    private String mETag;
    private int mConnectTimeout = 15000;
    private String mCharset = "UTF-8";
    private ExecutorService mCloseConnectionEngine;
    private OnHttpDownloadListener mOnHttpDownloadListener;

    public HttpDownloader(String url, Range range, String acceptRangeType, String eTag) {
        this.mUrl = url;
        this.mRange = range;
        this.mAcceptRangeType = acceptRangeType;
        this.mETag = eTag;
    }

    public void setOnHttpDownloadListener(OnHttpDownloadListener onHttpDownloadListener) {
        this.mOnHttpDownloadListener = onHttpDownloadListener;
    }

    public void setCloseConnectionEngine(ExecutorService closeConnectionEngine) {
        this.mCloseConnectionEngine = closeConnectionEngine;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
    }

    @Override
    public void download() throws HttpDownloadException {
        String url;
        boolean hasException;
        block22: {
            CloseConnectionTask closeConnectionTask;
            block21: {
                hasException = true;
                url = this.mUrl;
                HttpURLConnection conn = null;
                ContentLengthInputStream inputStream = null;
                try {
                    long contentLength;
                    int redirectTimes;
                    conn = HttpConnectionHelper.createDownloadFileConnection(url, this.mConnectTimeout, this.mCharset, this.mRange);
                    for (redirectTimes = 0; conn != null && conn.getResponseCode() / 100 == 3 && redirectTimes < 5; ++redirectTimes) {
                        conn = HttpConnectionHelper.createDownloadFileConnection(conn.getHeaderField("Location"), this.mConnectTimeout, this.mCharset, this.mRange);
                    }
                    Log.d(TAG, TAG + ".download 1\u3001\u51c6\u5907\u4e0b\u8f7d\uff0c\u91cd\u5b9a\u5411\uff1a" + redirectTimes + "\u6b21" + "\uff0c\u6700\u5927\u91cd\u5b9a\u5411\u6b21\u6570\uff1a" + 5 + "\uff0curl\uff1a" + url);
                    if (redirectTimes > 5) {
                        throw new HttpDownloadException("over max redirect:5!", HttpDownloadException.TYPE_REDIRECT_COUNT_OVER_LIMITS);
                    }
                    if (conn == null) {
                        throw new HttpDownloadException("the connection is null:5!", HttpDownloadException.TYPE_NULL_POINTER);
                    }
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200 || responseCode == 206) {
                        String contentLengthStr;
                        contentLength = conn.getContentLength();
                        if (contentLength <= 0L && !TextUtils.isEmpty((CharSequence)(contentLengthStr = conn.getHeaderField("Content-Length")))) {
                            contentLength = Long.parseLong(contentLengthStr);
                        }
                        Log.d(TAG, TAG + ".download 2\u3001\u5f97\u5230\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90contentLength\uff1a" + contentLength + "\uff0c\u4f20\u5165\u7684range\uff1a" + this.mRange.toString() + "\uff0curl\uff1a" + url);
                        if (contentLength <= 0L) {
                            throw new HttpDownloadException("content length illegal,get url file failed!", HttpDownloadException.TYPE_RESOURCES_SIZE_ILLEGAL);
                        }
                        if (!TextUtils.isEmpty((CharSequence)this.mETag)) {
                            String eTag = conn.getHeaderField("ETag");
                            Log.d(TAG, TAG + ".download 3\u3001\u5f97\u5230\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90eTag\uff1a" + eTag + "\uff0c\u4f20\u5165\u7684eTag\uff1a" + this.mETag + "\uff0curl\uff1a" + url);
                            if (TextUtils.isEmpty((CharSequence)eTag) || !this.mETag.equals(eTag)) {
                                throw new HttpDownloadException("eTag is not equal,please delete the old one then re-download!", HttpDownloadException.TYPE_ETAG_CHANGED);
                            }
                        }
                        if (!Range.isLegal(this.mRange) || this.mRange != null && this.mRange.getLength() > contentLength) {
                            this.mRange = new Range(0L, contentLength);
                        } else if (this.mRange != null && !TextUtils.isEmpty((CharSequence)this.mAcceptRangeType)) {
                            Range serverResponseRange;
                            boolean isRangeValidateSucceed = false;
                            String contentRange = conn.getHeaderField("Content-Range");
                            ContentRangeInfo contentRangeInfo = ContentRangeInfo.getContentRangeInfo(contentRange);
                            if (contentRangeInfo != null && this.mRange.equals(serverResponseRange = new Range(contentRangeInfo.startPos, contentRangeInfo.endPos)) && this.mAcceptRangeType.equals(contentRangeInfo.contentType) && serverResponseRange.getLength() == contentLength) {
                                isRangeValidateSucceed = true;
                            }
                            if (!isRangeValidateSucceed) {
                                throw new HttpDownloadException("contentRange validate failed!", HttpDownloadException.TYPE_CONTENT_RANGE_VALIDATE_FAIL);
                            }
                        }
                    } else {
                        throw new HttpDownloadException("ResponseCode:" + responseCode + " error,can not read server data!", HttpDownloadException.TYPE_RESPONSE_CODE_ERROR);
                    }
                    InputStream serverInputStream = conn.getInputStream();
                    inputStream = new ContentLengthInputStream(serverInputStream, contentLength);
                    Log.d(TAG, TAG + ".download 4\u3001\u51c6\u5907\u5904\u7406\u6570\u636e\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90\u957f\u5ea6\u4e3a\uff1a" + contentLength + "\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8f93\u5165\u6d41\u957f\u5ea6\u4e3a\uff1a" + inputStream.available() + "\uff0c\u9700\u8981\u5904\u7406\u7684\u533a\u57df\u4e3a\uff1a" + this.mRange.toString() + "\uff0curl\uff1a" + url);
                    this.notifyDownloadConnected(inputStream, this.mRange.startPos);
                    hasException = false;
                    closeConnectionTask = new CloseConnectionTask(conn, inputStream);
                    if (this.mCloseConnectionEngine == null) break block21;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        hasException = true;
                        if (e instanceof HttpDownloadException) {
                            throw (HttpDownloadException)e;
                        }
                        throw new HttpDownloadException(e);
                    }
                    catch (Throwable throwable) {
                        CloseConnectionTask closeConnectionTask2 = new CloseConnectionTask(conn, inputStream);
                        if (this.mCloseConnectionEngine != null) {
                            this.mCloseConnectionEngine.execute(closeConnectionTask2);
                        } else {
                            closeConnectionTask2.run();
                        }
                        Log.d(TAG, TAG + ".download 5\u3001Http\u6587\u4ef6\u4e0b\u8f7d\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + url);
                        throw throwable;
                    }
                }
                this.mCloseConnectionEngine.execute(closeConnectionTask);
                break block22;
            }
            closeConnectionTask.run();
        }
        Log.d(TAG, TAG + ".download 5\u3001Http\u6587\u4ef6\u4e0b\u8f7d\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + hasException + "\uff0curl\uff1a" + url);
    }

    private void notifyDownloadConnected(ContentLengthInputStream inputStream, long startPosInTotal) {
        if (this.mOnHttpDownloadListener != null) {
            this.mOnHttpDownloadListener.onDownloadConnected(inputStream, startPosInTotal);
        }
    }

    public static interface OnHttpDownloadListener {
        public void onDownloadConnected(ContentLengthInputStream var1, long var2);
    }

    public static class HttpDownloadException
    extends HttpFailReason {
        public static final String TYPE_REDIRECT_COUNT_OVER_LIMITS = HttpDownloadException.class.getName() + "_TYPE_REDIRECT_COUNT_OVER_LIMITS";
        public static final String TYPE_RESOURCES_SIZE_ILLEGAL = HttpDownloadException.class.getName() + "_TYPE_RESOURCES_SIZE_ILLEGAL";
        public static final String TYPE_ETAG_CHANGED = HttpDownloadException.class.getName() + "_TYPE_ETAG_CHANGED";
        public static final String TYPE_CONTENT_RANGE_VALIDATE_FAIL = HttpDownloadException.class.getName() + "_TYPE_CONTENT_RANGE_VALIDATE_FAIL";
        public static final String TYPE_RESPONSE_CODE_ERROR = HttpDownloadException.class.getName() + "_TYPE_RESPONSE_CODE_ERROR";

        public HttpDownloadException(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public HttpDownloadException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithFailReason(FailReason failReason) {
            FileSaver.FileSaveException fileSaveException;
            String type;
            super.onInitTypeWithFailReason(failReason);
            if (failReason == null) {
                return;
            }
            if (!(failReason instanceof FileSaver.FileSaveException) || FileSaver.FileSaveException.TYPE_FILE_CAN_NOT_STORAGE.equals(type = (fileSaveException = (FileSaver.FileSaveException)failReason).getType()) || FileSaver.FileSaveException.TYPE_RENAME_TEMP_FILE_ERROR.equals(type) || FileSaver.FileSaveException.TYPE_SAVER_HAS_BEEN_STOPPED.equals(type) || FileSaver.FileSaveException.TYPE_TEMP_FILE_DOES_NOT_EXIST.equals(type)) {
                // empty if block
            }
        }
    }
}

