/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.text.TextUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import org.wlf.filedownloader.file_download.http_downloader.Range;
import org.wlf.filedownloader.util.UrlUtil;

public class HttpConnectionHelper {
    public static HttpURLConnection createDetectConnection(String url, int connectTimeout, String charset) throws Exception {
        return HttpConnectionHelper.createHttpUrlConnection(url, connectTimeout, charset, -1L, -1L);
    }

    public static HttpURLConnection createDownloadFileConnection(String url, int connectTimeout, String charset, Range range) throws Exception {
        long rangeStartPos = -1L;
        long rangeEndPos = -1L;
        if (Range.isLegal(range)) {
            rangeStartPos = range.startPos;
            rangeEndPos = range.endPos;
        }
        return HttpConnectionHelper.createHttpUrlConnection(url, connectTimeout, charset, rangeStartPos, rangeEndPos);
    }

    public static HttpURLConnection createHttpUrlConnection(String url, int connectTimeout, String charset, long rangeStartPos, long rangeEndPos) throws Exception {
        return HttpConnectionHelper.createHttpUrlConnectionInternal(url, connectTimeout, charset, rangeStartPos, rangeEndPos);
    }

    private static HttpURLConnection createHttpUrlConnectionInternal(String url, int connectTimeout, String charset, long rangeStartPos, long rangeEndPos) throws Exception {
        String encodedUrl = UrlUtil.getASCIIEncodedUrl(url);
        if (TextUtils.isEmpty((CharSequence)encodedUrl)) {
            throw new IllegalAccessException("URL Illegal !");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(encodedUrl).openConnection();
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(connectTimeout);
        conn.setRequestProperty("Charset", charset);
        conn.setRequestProperty("Accept-Encoding", "identity");
        if (rangeStartPos > 0L && rangeEndPos > 0L && rangeEndPos > rangeStartPos) {
            conn.setRequestProperty("Range", "bytes=" + rangeStartPos + "-" + rangeEndPos);
        }
        conn.connect();
        return conn;
    }
}

