/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadStatusConfiguration;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.DetectUrlFileCacher;
import org.wlf.filedownloader.file_download.DetectUrlFileInfo;
import org.wlf.filedownloader.file_download.DetectUrlFileTask;
import org.wlf.filedownloader.file_download.DownloadStatusObserver;
import org.wlf.filedownloader.file_download.FileDownloadTaskParam;
import org.wlf.filedownloader.file_download.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.RetryableDownloadTaskImpl;
import org.wlf.filedownloader.file_download.base.DownloadRecorder;
import org.wlf.filedownloader.file_download.base.DownloadTask;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.listener.OnDetectBigUrlFileListener;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.NetworkUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadTaskManager
implements Pauseable {
    private static final String TAG = DownloadTaskManager.class.getSimpleName();
    private FileDownloadConfiguration mConfiguration;
    private DownloadRecorder mDownloadRecorder;
    private DetectUrlFileCacher mDetectUrlFileCacher;
    private DownloadStatusObserver mDownloadStatusObserver;
    private Map<String, DownloadTask> mRunningDownloadTaskMap = new ConcurrentHashMap<String, DownloadTask>();

    public DownloadTaskManager(FileDownloadConfiguration configuration, DownloadRecorder downloadRecorder) {
        this.mConfiguration = configuration;
        this.mDownloadRecorder = downloadRecorder;
        this.mDetectUrlFileCacher = new DetectUrlFileCacher();
        this.mDownloadStatusObserver = new DownloadStatusObserver();
    }

    public void release(final OnReleaseListener onReleaseListener) {
        final Set<String> runningUrls = this.mRunningDownloadTaskMap.keySet();
        this.pause(new ArrayList<String>(runningUrls), new OnStopFileDownloadTaskListener(){
            private List<String> mSucceed = new ArrayList<String>();
            private List<String> mFailed = new ArrayList<String>();
            private boolean mIsNotify = false;

            @Override
            public void onStopFileDownloadTaskSucceed(String url) {
                this.mSucceed.add(url);
                if (runningUrls.size() == this.mSucceed.size() + this.mFailed.size()) {
                    if (this.mIsNotify) {
                        return;
                    }
                    DownloadTaskManager.this.notifyReleased(onReleaseListener);
                    this.mIsNotify = true;
                }
            }

            @Override
            public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                this.mFailed.add(url);
                if (runningUrls.size() == this.mSucceed.size() + this.mFailed.size()) {
                    if (this.mIsNotify) {
                        return;
                    }
                    DownloadTaskManager.this.notifyReleased(onReleaseListener);
                }
            }
        });
    }

    private DetectUrlFileInfo getDetectUrlFile(String url) {
        return this.mDetectUrlFileCacher.getDetectUrlFile(url);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadRecorder.getDownloadFile(url);
    }

    private DownloadTask getRunningDownloadTask(String url) {
        DownloadTask task;
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return this.mRunningDownloadTaskMap.get(url);
        }
        if (DownloadFileUtil.isDownloadingStatus(downloadFileInfo) && (task = this.mRunningDownloadTaskMap.get(url)) != null && !task.isStopped()) {
            return task;
        }
        if (this.mRunningDownloadTaskMap.containsKey(url)) {
            this.mRunningDownloadTaskMap.remove(url);
        }
        return null;
    }

    public void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener, DownloadStatusConfiguration downloadStatusConfiguration) {
        this.mDownloadStatusObserver.addOnFileDownloadStatusListener(onFileDownloadStatusListener, downloadStatusConfiguration);
    }

    public void unregisterDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mDownloadStatusObserver.removeOnFileDownloadStatusListener(onFileDownloadStatusListener);
    }

    private void addAndRunDetectUrlFileTask(String url, boolean forceDetect, OnDetectBigUrlFileListener onDetectBigUrlFileListener) {
        OnDetectUrlFileListener.DetectUrlFileFailReason failReason = null;
        if (!UrlUtil.isUrl(url)) {
            failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("url illegal !", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_URL_ILLEGAL);
        }
        if (failReason == null && !NetworkUtil.isNetworkAvailable(this.mConfiguration.getContext())) {
            failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("network not available !", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_NETWORK_DENIED);
        }
        if (failReason != null) {
            this.notifyDetectUrlFileFailed(url, failReason, onDetectBigUrlFileListener);
            return;
        }
        DetectUrlFileTask detectUrlFileTask = new DetectUrlFileTask(url, this.mConfiguration.getFileDownloadDir(), this.mDetectUrlFileCacher, this.mDownloadRecorder);
        detectUrlFileTask.setOnDetectBigUrlFileListener(onDetectBigUrlFileListener);
        detectUrlFileTask.setCloseConnectionEngine(this.mConfiguration.getFileOperationEngine());
        detectUrlFileTask.setConnectTimeout(this.mConfiguration.getConnectTimeout());
        if (forceDetect) {
            detectUrlFileTask.enableForceDetect();
        }
        this.mConfiguration.getFileDetectEngine().execute(detectUrlFileTask);
    }

    private void addAndRunDownloadTask(String callerUrl, DownloadFileInfo downloadFileInfo) {
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (!UrlUtil.isUrl(callerUrl)) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("url illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_URL_ILLEGAL);
        }
        if (failReason == null && !NetworkUtil.isNetworkAvailable(this.mConfiguration.getContext())) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("network not available !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NETWORK_DENIED);
        }
        if (failReason == null) {
            if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the download file does not exist or illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
            }
            if (!(failReason != null || !TextUtils.isEmpty((CharSequence)callerUrl) && callerUrl.equals(downloadFileInfo.getUrl()) && downloadFileInfo.equals(this.getDownloadFile(callerUrl)))) {
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the download file does not exist or illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
            }
        }
        if (failReason != null) {
            this.notifyDownloadStatusFailed(callerUrl, failReason, downloadFileInfo != null);
            return;
        }
        if (this.isDownloading(callerUrl)) {
            return;
        }
        RetryableDownloadTaskImpl downloadTask = new RetryableDownloadTaskImpl(FileDownloadTaskParam.createByDownloadFile(downloadFileInfo), this.mDownloadRecorder, this.mDownloadStatusObserver);
        downloadTask.setRetryDownloadTimes(this.mConfiguration.getRetryDownloadTimes());
        downloadTask.setCloseConnectionEngine(this.mConfiguration.getFileOperationEngine());
        downloadTask.setConnectTimeout(this.mConfiguration.getConnectTimeout());
        this.mRunningDownloadTaskMap.put(downloadTask.getUrl(), downloadTask);
        this.mConfiguration.getFileDownloadEngine().execute(downloadTask);
    }

    private void notifyDetectUrlFileFailed(String url, OnDetectBigUrlFileListener.DetectBigUrlFileFailReason failReason, OnDetectBigUrlFileListener onDetectBigUrlFileListener) {
        Log.d(TAG, "\u63a2\u6d4b\u6587\u4ef6\u5931\u8d25\uff0curl\uff1a" + url);
        OnDetectBigUrlFileListener.MainThreadHelper.onDetectUrlFileFailed(url, failReason, onDetectBigUrlFileListener);
    }

    private boolean notifyDownloadStatusFailed(String url, final OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason, final boolean recordStatus) {
        if (this.isDownloading(url)) {
            this.pause(url, new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    DownloadTaskManager.this.notifyDownloadStatusFailedInternal(url, failReason, recordStatus);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason stopFailReason) {
                    OnFileDownloadStatusListener.FileDownloadStatusFailReason notifyFailReason = failReason == null ? new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(stopFailReason) : failReason;
                    DownloadTaskManager.this.notifyDownloadStatusFailedInternal(url, notifyFailReason, recordStatus);
                }
            });
            return true;
        }
        return this.notifyDownloadStatusFailedInternal(url, failReason, recordStatus);
    }

    private boolean notifyDownloadStatusFailedInternal(String url, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason, boolean recordStatus) {
        if (recordStatus) {
            try {
                this.mDownloadRecorder.recordStatus(url, 7, 0);
                this.mDownloadStatusObserver.onFileDownloadStatusFailed(url, this.getDownloadFile(url), failReason);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.mDownloadStatusObserver.onFileDownloadStatusFailed(url, this.getDownloadFile(url), failReason);
        return true;
    }

    private void notifyStopDownloadTaskSucceed(String url, OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        if (this.mRunningDownloadTaskMap.containsKey(url)) {
            this.mRunningDownloadTaskMap.remove(url);
        }
        if (onStopFileDownloadTaskListener != null) {
            onStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(url);
        }
    }

    private void notifyStopDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason, OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        DownloadTask downloadTask = this.getRunningDownloadTask(url);
        if (downloadTask != null && downloadTask.isStopped() && this.mRunningDownloadTaskMap.containsKey(url)) {
            this.mRunningDownloadTaskMap.remove(url);
        }
        if (onStopFileDownloadTaskListener != null) {
            onStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(url, failReason);
        }
    }

    private void notifyReleased(OnReleaseListener onReleaseListener) {
        this.mDetectUrlFileCacher.release();
        this.mDownloadStatusObserver.release();
        if (onReleaseListener != null) {
            onReleaseListener.onReleased();
        }
    }

    private void detectInternal(String url, boolean forceDetect, OnDetectBigUrlFileListener onDetectBigUrlFileListener) {
        this.addAndRunDetectUrlFileTask(url, forceDetect, onDetectBigUrlFileListener);
    }

    @Deprecated
    public void detect(String url, final OnDetectUrlFileListener onDetectUrlFileListener) {
        this.detect(url, new OnDetectBigUrlFileListener(){

            @Override
            public void onDetectNewDownloadFile(String url, String fileName, String saveDir, long fileSize) {
                if (onDetectUrlFileListener != null) {
                    onDetectUrlFileListener.onDetectNewDownloadFile(url, fileName, saveDir, (int)fileSize);
                }
            }

            @Override
            public void onDetectUrlFileExist(String url) {
                if (onDetectUrlFileListener != null) {
                    onDetectUrlFileListener.onDetectUrlFileExist(url);
                }
            }

            @Override
            public void onDetectUrlFileFailed(String url, OnDetectBigUrlFileListener.DetectBigUrlFileFailReason failReason) {
                if (onDetectUrlFileListener != null) {
                    onDetectUrlFileListener.onDetectUrlFileFailed(url, new OnDetectUrlFileListener.DetectUrlFileFailReason(failReason));
                }
            }
        });
    }

    public void detect(String url, OnDetectBigUrlFileListener onDetectBigUrlFileListener) {
        this.detectInternal(url, false, onDetectBigUrlFileListener);
    }

    public void createAndStart(String url, String saveDir, String fileName) {
        DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
        if (detectUrlFileInfo != null) {
            detectUrlFileInfo.setFileDir(saveDir);
            detectUrlFileInfo.setFileName(fileName);
        }
        this.createAndStartByDetectUrlFile(url, detectUrlFileInfo);
    }

    private void createAndStartByDetectUrlFile(String callerUrl, DetectUrlFileInfo detectUrlFileInfo) {
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (!(DownloadFileUtil.isLegal(detectUrlFileInfo) || (failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist, please use detect(String,OnDetectBigUrlFileListener) first !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT)) != null || UrlUtil.isUrl(callerUrl) && callerUrl.equals(detectUrlFileInfo.getUrl()))) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist, please use detect(String,OnDetectBigUrlFileListener) first !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT);
        }
        if (failReason != null) {
            this.notifyDownloadStatusFailed(callerUrl, failReason, this.getDownloadFile(callerUrl) != null);
            return;
        }
        DownloadFileInfo downloadFileInfo = this.mDownloadRecorder.createDownloadFileInfo(detectUrlFileInfo);
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            this.removeDetectUrlFile(detectUrlFileInfo.getUrl());
        }
        this.startInternal(callerUrl, downloadFileInfo);
    }

    private void startInternal(String callerUrl, DownloadFileInfo downloadFileInfo) {
        this.addAndRunDownloadTask(callerUrl, downloadFileInfo);
    }

    public void start(String url) {
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            this.startInternal(url, downloadFileInfo);
        } else {
            DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
            if (detectUrlFileInfo != null) {
                this.createAndStartByDetectUrlFile(url, detectUrlFileInfo);
            } else {
                final String finalUrl = url;
                this.detect(finalUrl, new OnDetectBigUrlFileListener(){

                    @Override
                    public void onDetectUrlFileFailed(String url, OnDetectBigUrlFileListener.DetectBigUrlFileFailReason failReason) {
                        DownloadTaskManager.this.notifyDownloadStatusFailed(finalUrl, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), false);
                    }

                    @Override
                    public void onDetectUrlFileExist(String url) {
                        DownloadTaskManager.this.startInternal(finalUrl, DownloadTaskManager.this.getDownloadFile(finalUrl));
                    }

                    @Override
                    public void onDetectNewDownloadFile(String url, String fileName, String savedDir, long fileSize) {
                        DownloadTaskManager.this.createAndStart(finalUrl, savedDir, fileName);
                    }
                });
            }
        }
    }

    public void start(List<String> urls) {
        for (String url : urls) {
            this.start(url);
        }
    }

    private void pauseInternal(String url, final OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        DownloadTask downloadTask = this.getRunningDownloadTask(url);
        Log.d(TAG, "pauseInternal fileDownloadTask\u662f\u5426\u5df2\u7ecf\u505c\u6b62\uff1a" + (downloadTask != null ? downloadTask.isStopped() : true) + ",url\uff1a" + url);
        final String finalUrl = url;
        if (downloadTask != null && !downloadTask.isStopped()) {
            downloadTask.setOnStopFileDownloadTaskListener(new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d(TAG, "pauseInternal \u6682\u505c\u6210\u529f\uff0curl\uff1a" + finalUrl);
                    DownloadTaskManager.this.notifyStopDownloadTaskSucceed(finalUrl, onStopFileDownloadTaskListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                    Log.d(TAG, "pauseInternal \u6682\u505c\u5931\u8d25\uff0curl\uff1a" + finalUrl + ",failReason:" + failReason.getType());
                    DownloadTaskManager.this.notifyStopDownloadTaskFailed(finalUrl, failReason, onStopFileDownloadTaskListener);
                }
            });
            downloadTask.stop();
        } else {
            OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason = new OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason("the download task has been paused !", OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED);
            Log.d(TAG, "pauseInternal \u4efb\u52a1\u5df2\u7ecf\u88ab\u6682\u505c\uff0curl\uff1a" + url + ",failReason:" + failReason.getType());
            DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
            if (DownloadFileUtil.isDownloadingStatus(downloadFileInfo)) {
                try {
                    this.mDownloadRecorder.recordStatus(url, 6, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.notifyStopDownloadTaskFailed(url, failReason, onStopFileDownloadTaskListener);
        }
    }

    @Override
    public boolean isDownloading(String url) {
        return this.getRunningDownloadTask(url) != null;
    }

    @Override
    public void pause(String url, OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.pauseInternal(url, onStopFileDownloadTaskListener);
    }

    public void pause(List<String> urls, OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        for (String url : urls) {
            this.pause(url, onStopFileDownloadTaskListener);
        }
    }

    public void pauseAll(OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        Set<String> urls = this.mRunningDownloadTaskMap.keySet();
        this.pause(new ArrayList<String>(urls), onStopFileDownloadTaskListener);
    }

    private void reStartInternal(String url, final boolean isDelete) {
        if (!UrlUtil.isUrl(url)) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("url illegal !", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_URL_ILLEGAL);
            this.notifyDownloadStatusFailed(url, failReason, this.getDownloadFile(url) != null);
            return;
        }
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (DownloadFileUtil.isLegal(downloadFileInfo)) {
            final String finalUrl = url;
            final String oldFileName = downloadFileInfo.getFileName();
            final String oldFileDir = downloadFileInfo.getFileDir();
            this.detectInternal(url, true, new OnDetectBigUrlFileListener(){

                @Override
                public void onDetectNewDownloadFile(String url, String fileName, String saveDir, long fileSize) {
                    try {
                        DownloadTaskManager.this.mDownloadRecorder.resetDownloadFile(finalUrl, isDelete);
                        DownloadTaskManager.this.createAndStart(finalUrl, oldFileDir, oldFileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e);
                        DownloadTaskManager.this.notifyDownloadStatusFailed(finalUrl, failReason, DownloadTaskManager.this.getDownloadFile(finalUrl) != null);
                    }
                }

                @Override
                public void onDetectUrlFileExist(String url) {
                    try {
                        DownloadTaskManager.this.mDownloadRecorder.resetDownloadFile(finalUrl, isDelete);
                        DownloadTaskManager.this.start(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e);
                        DownloadTaskManager.this.notifyDownloadStatusFailed(finalUrl, failReason, DownloadTaskManager.this.getDownloadFile(finalUrl) != null);
                    }
                }

                @Override
                public void onDetectUrlFileFailed(String url, OnDetectBigUrlFileListener.DetectBigUrlFileFailReason failReason) {
                    DownloadTaskManager.this.notifyDownloadStatusFailed(finalUrl, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), DownloadTaskManager.this.getDownloadFile(finalUrl) != null);
                }
            });
        } else {
            this.start(url);
        }
    }

    public void reStart(String url) {
        if (this.isDownloading(url)) {
            final String finalUrl = url;
            this.pause(url, new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    DownloadTaskManager.this.reStartInternal(finalUrl, true);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                    if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                        DownloadTaskManager.this.reStartInternal(finalUrl, true);
                        return;
                    }
                    DownloadTaskManager.this.notifyDownloadStatusFailed(finalUrl, failReason, DownloadTaskManager.this.getDownloadFile(finalUrl) != null);
                }
            });
        } else {
            this.reStartInternal(url, true);
        }
    }

    public void reStart(List<String> urls) {
        for (String url : urls) {
            this.reStart(url);
        }
    }

    private void removeDetectUrlFile(String url) {
        this.mDetectUrlFileCacher.removeDetectUrlFile(url);
    }

    public static interface OnReleaseListener {
        public void onReleased();
    }
}

