/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadStatusConfiguration;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnRetryableFileDownloadStatusListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadStatusObserver
implements OnRetryableFileDownloadStatusListener {
    private static final String TAG = DownloadStatusObserver.class.getSimpleName();
    private Set<DownloadStatusListenerInfo> mDownloadStatusListenerInfos = new CopyOnWriteArraySet<DownloadStatusListenerInfo>();

    DownloadStatusObserver() {
    }

    public void addOnFileDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener, DownloadStatusConfiguration downloadStatusConfiguration) {
        if (onFileDownloadStatusListener == null) {
            return;
        }
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null) {
                return;
            }
            if (listenerInfo.mListener != onFileDownloadStatusListener) continue;
            return;
        }
        DownloadStatusListenerInfo listenerInfo = new DownloadStatusListenerInfo(downloadStatusConfiguration, onFileDownloadStatusListener);
        this.mDownloadStatusListenerInfos.add(listenerInfo);
        String urls = downloadStatusConfiguration != null && !CollectionUtil.isEmpty(downloadStatusConfiguration.getListenUrls()) ? downloadStatusConfiguration.getListenUrls().toString() : "all";
        Log.i(TAG, "file-downloader-listener \u6dfb\u52a0\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u76d1\u542c\u5668\u3011\u6210\u529f\uff0c\u8be5listener\u76d1\u542c\u7684urls\uff1a" + urls);
    }

    public void removeOnFileDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        if (onFileDownloadStatusListener == null) {
            return;
        }
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener != onFileDownloadStatusListener) continue;
            this.mDownloadStatusListenerInfos.remove(listenerInfo);
            String urls = listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls()) ? listenerInfo.mDownloadStatusConfiguration.getListenUrls().toString() : "all";
            Log.i(TAG, "file-downloader-listener \u79fb\u9664\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u76d1\u542c\u5668\u3011\u6210\u529f\uff0c\u8be5listener\u76d1\u542c\u7684urls\uff1a" + urls);
            break;
        }
    }

    private void notifyStatusWaiting(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusWaiting(downloadFileInfo, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u7b49\u5f85\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusRetrying(DownloadFileInfo downloadFileInfo, int retryTimes, OnFileDownloadStatusListener listener) {
        if (listener instanceof OnRetryableFileDownloadStatusListener) {
            OnRetryableFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusRetrying(downloadFileInfo, retryTimes, (OnRetryableFileDownloadStatusListener)listener);
            String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
            Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u91cd\u8bd5\u3011\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + retryTimes + "\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
        }
    }

    private void notifyStatusPreparing(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPreparing(downloadFileInfo, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u51c6\u5907\u4e2d\uff08\u6b63\u5728\u8fde\u63a5\uff09\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusPrepared(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPrepared(downloadFileInfo, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u5df2\u51c6\u5907\uff08\u5df2\u8fde\u63a5\uff09\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusDownloading(DownloadFileInfo downloadFileInfo, float downloadSpeed, long remainingTime, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u6b63\u5728\u4e0b\u8f7d\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusPaused(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPaused(downloadFileInfo, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u6682\u505c\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusCompleted(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusCompleted(downloadFileInfo, listener);
        String url = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u5b8c\u6210\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url);
    }

    private void notifyStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason, OnFileDownloadStatusListener listener) {
        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(url, downloadFileInfo, failReason, listener);
        String downloadFileUrl = downloadFileInfo != null ? downloadFileInfo.getUrl() : "unknown";
        String failMsg = failReason != null ? failReason.getMessage() : "unknown";
        Log.i(TAG, "file-downloader-listener \u901a\u77e5\u3010\u6587\u4ef6\u4e0b\u8f7d\u72b6\u6001\u4e3a\u5931\u8d25\u3011\uff0c\u6587\u4ef6\u7684url\uff1a" + url + "\uff0cdownloadFileUrl\uff1a" + downloadFileUrl + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + failMsg);
    }

    @Override
    public void onFileDownloadStatusWaiting(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusWaiting(downloadFileInfo, listenerInfo.mListener);
                }
                continue;
            }
            this.notifyStatusWaiting(downloadFileInfo, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusRetrying(DownloadFileInfo downloadFileInfo, int retryTimes) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this || !(listenerInfo.mListener instanceof OnRetryableFileDownloadStatusListener)) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusRetrying(downloadFileInfo, retryTimes, listenerInfo.mListener);
                }
                continue;
            }
            this.notifyStatusRetrying(downloadFileInfo, retryTimes, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusPreparing(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusPreparing(downloadFileInfo, listenerInfo.mListener);
                }
                continue;
            }
            this.notifyStatusPreparing(downloadFileInfo, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusPrepared(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusPrepared(downloadFileInfo, listenerInfo.mListener);
                }
                continue;
            }
            this.notifyStatusPrepared(downloadFileInfo, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusDownloading(DownloadFileInfo downloadFileInfo, float downloadSpeed, long remainingTime) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime, listenerInfo.mListener);
                }
                continue;
            }
            this.notifyStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusPaused(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusPaused(downloadFileInfo, listenerInfo.mListener);
                    if (!listenerInfo.mDownloadStatusConfiguration.isAutoRelease()) continue;
                    this.mDownloadStatusListenerInfos.remove(listenerInfo);
                }
                continue;
            }
            this.notifyStatusPaused(downloadFileInfo, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusCompleted(DownloadFileInfo downloadFileInfo) {
        if (!DownloadFileUtil.isLegal(downloadFileInfo)) {
            return;
        }
        String url = downloadFileInfo.getUrl();
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusCompleted(downloadFileInfo, listenerInfo.mListener);
                    if (!listenerInfo.mDownloadStatusConfiguration.isAutoRelease()) continue;
                    this.mDownloadStatusListenerInfos.remove(listenerInfo);
                }
                continue;
            }
            this.notifyStatusCompleted(downloadFileInfo, listenerInfo.mListener);
        }
    }

    @Override
    public void onFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason) {
        if (!UrlUtil.isUrl(url)) {
            return;
        }
        for (DownloadStatusListenerInfo listenerInfo : this.mDownloadStatusListenerInfos) {
            if (listenerInfo == null || listenerInfo.mListener == null || listenerInfo.mListener == this) continue;
            if (listenerInfo.mDownloadStatusConfiguration != null && !CollectionUtil.isEmpty(listenerInfo.mDownloadStatusConfiguration.getListenUrls())) {
                for (String listenUrl : listenerInfo.mDownloadStatusConfiguration.getListenUrls()) {
                    if (!UrlUtil.isUrl(listenUrl) || !url.equals(listenUrl) && !url.trim().equals(listenUrl.trim())) continue;
                    this.notifyStatusFailed(url, downloadFileInfo, failReason, listenerInfo.mListener);
                    if (!listenerInfo.mDownloadStatusConfiguration.isAutoRelease()) continue;
                    this.mDownloadStatusListenerInfos.remove(listenerInfo);
                }
                continue;
            }
            this.notifyStatusFailed(url, downloadFileInfo, failReason, listenerInfo.mListener);
        }
    }

    public void release() {
        this.mDownloadStatusListenerInfos.clear();
    }

    private static class DownloadStatusListenerInfo {
        private DownloadStatusConfiguration mDownloadStatusConfiguration;
        private OnFileDownloadStatusListener mListener;

        public DownloadStatusListenerInfo(DownloadStatusConfiguration downloadStatusConfiguration, OnFileDownloadStatusListener listener) {
            this.mDownloadStatusConfiguration = downloadStatusConfiguration;
            this.mListener = listener;
        }
    }
}

