/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_delete;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_delete.DeleteDownloadFileTask;
import org.wlf.filedownloader.file_delete.DeleteDownloadFilesTask;
import org.wlf.filedownloader.file_delete.DownloadFileDeleter;
import org.wlf.filedownloader.file_download.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;

public class DownloadDeleteManager {
    private static final String TAG = DownloadDeleteManager.class.getSimpleName();
    private ExecutorService mTaskEngine;
    private DownloadFileDeleter mDownloadFileDeleter;
    private Pauseable mDownloadTaskPauseable;
    private DeleteControl mDeleteControl;

    public DownloadDeleteManager(ExecutorService taskEngine, DownloadFileDeleter downloadFileDeleter, Pauseable downloadTaskPauseable) {
        this.mTaskEngine = taskEngine;
        this.mDownloadFileDeleter = downloadFileDeleter;
        this.mDownloadTaskPauseable = downloadTaskPauseable;
    }

    private void addAndRunTask(Runnable task) {
        this.mTaskEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileDeleter.getDownloadFile(url);
    }

    private void singleDeleteInternal(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        DeleteDownloadFileTask deleteDownloadFileTask = new DeleteDownloadFileTask(url, deleteDownloadedFileInPath, this.mDownloadFileDeleter);
        deleteDownloadFileTask.setOnDeleteDownloadFileListener(onDeleteDownloadFileListener);
        this.addAndRunTask(deleteDownloadFileTask);
    }

    public void delete(String url, final boolean deleteDownloadedFileInPath, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        final String finalUrl = url;
        if (!this.mDownloadTaskPauseable.isDownloading(url)) {
            Log.d(TAG, TAG + ".delete \u4e0b\u8f7d\u4efb\u52a1\u5df2\u7ecf\u6682\u505c\uff0c\u53ef\u4ee5\u76f4\u63a5\u5220\u9664\uff0curl:" + url);
            this.singleDeleteInternal(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
        } else {
            Log.d(TAG, TAG + ".delete \u9700\u8981\u5148\u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u540e\u5220\u9664,url:" + url);
            this.mDownloadTaskPauseable.pause(url, new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d(TAG, TAG + ".delete \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u6210\u529f\uff0c\u5f00\u59cb\u5220\u9664\uff0curl:" + finalUrl);
                    DownloadDeleteManager.this.singleDeleteInternal(finalUrl, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                    if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                        DownloadDeleteManager.this.singleDeleteInternal(finalUrl, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
                        return;
                    }
                    Log.d(TAG, TAG + ".delete \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u5220\u9664\uff0curl:" + finalUrl);
                    DownloadDeleteManager.this.notifyDeleteDownloadFileFailed(DownloadDeleteManager.this.getDownloadFile(finalUrl), new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(failReason), onDeleteDownloadFileListener);
                }
            });
        }
    }

    public Control delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        if (this.mDeleteControl != null && !this.mDeleteControl.isStopped()) {
            return this.mDeleteControl;
        }
        DeleteDownloadFilesTask deleteDownloadFilesTask = new DeleteDownloadFilesTask(urls, deleteDownloadedFile, this.mTaskEngine, this.mDownloadFileDeleter, this.mDownloadTaskPauseable);
        deleteDownloadFilesTask.setOnDeleteDownloadFilesListener(onDeleteDownloadFilesListener);
        this.addAndRunTask(deleteDownloadFilesTask);
        this.mDeleteControl = new DeleteControl(deleteDownloadFilesTask);
        return this.mDeleteControl;
    }

    private void notifyDeleteDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnDeleteDownloadFileListener.DeleteDownloadFileFailReason failReason, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileFailed(downloadFileInfo, failReason, onDeleteDownloadFileListener);
    }

    private class DeleteControl
    implements Control {
        private DeleteDownloadFilesTask mDeleteDownloadFilesTask;

        private DeleteControl(DeleteDownloadFilesTask deleteDownloadFilesTask) {
            this.mDeleteDownloadFilesTask = deleteDownloadFilesTask;
        }

        @Override
        public void stop() {
            if (this.mDeleteDownloadFilesTask != null) {
                this.mDeleteDownloadFilesTask.stop();
            }
        }

        @Override
        public boolean isStopped() {
            if (this.mDeleteDownloadFilesTask == null) {
                return true;
            }
            return this.mDeleteDownloadFilesTask.isStopped();
        }
    }
}

