/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class DownloadFileChangeConfiguration {
    private Builder mBuilder;

    private DownloadFileChangeConfiguration(Builder builder) {
        this.mBuilder = builder;
    }

    public Set<String> getListenUrls() {
        if (this.mBuilder == null) {
            return null;
        }
        return this.mBuilder.mListenUrls;
    }

    public boolean isTreadCallback() {
        if (this.mBuilder == null) {
            return false;
        }
        return this.mBuilder.mIsThreadCallback;
    }

    public static class Builder {
        private Set<String> mListenUrls;
        private boolean mIsThreadCallback = false;

        public Builder addListenUrl(String url) {
            if (UrlUtil.isUrl(url)) {
                if (this.mListenUrls == null) {
                    this.mListenUrls = new HashSet<String>();
                }
                this.mListenUrls.add(url);
            }
            return this;
        }

        public Builder addListenUrls(List<String> urls) {
            ArrayList<String> needAdd = new ArrayList<String>();
            for (String url : urls) {
                if (!UrlUtil.isUrl(url)) continue;
                needAdd.add(url);
            }
            if (!CollectionUtil.isEmpty(needAdd)) {
                if (this.mListenUrls == null) {
                    this.mListenUrls = new HashSet<String>();
                }
                this.mListenUrls.addAll(needAdd);
            }
            return this;
        }

        public Builder configTreadCallback(boolean isThreadCallback) {
            this.mIsThreadCallback = isThreadCallback;
            return this;
        }

        public DownloadFileChangeConfiguration build() {
            return new DownloadFileChangeConfiguration(this);
        }
    }
}

