/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.listener.HttpFailReason;

public interface OnDetectUrlFileListener {
    public void onDetectNewDownloadFile(String var1, String var2, String var3, int var4);

    public void onDetectUrlFileExist(String var1);

    public void onDetectUrlFileFailed(String var1, DetectUrlFileFailReason var2);

    public static class DetectUrlFileFailReason
    extends HttpFailReason {
        private static final long serialVersionUID = -6863373572721814857L;

        public DetectUrlFileFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public DetectUrlFileFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onDetectNewDownloadFile(final String url, final String fileName, final String saveDir, final int fileSize, final OnDetectUrlFileListener onDetectUrlFileListener) {
            if (onDetectUrlFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDetectUrlFileListener.onDetectNewDownloadFile(url, fileName, saveDir, fileSize);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDetectUrlFileExist(final String url, final OnDetectUrlFileListener onDetectUrlFileListener) {
            if (onDetectUrlFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDetectUrlFileListener.onDetectUrlFileExist(url);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }

        public static void onDetectUrlFileFailed(final String url, final DetectUrlFileFailReason failReason, final OnDetectUrlFileListener onDetectUrlFileListener) {
            if (onDetectUrlFileListener == null) {
                return;
            }
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    onDetectUrlFileListener.onDetectUrlFileFailed(url, failReason);
                    handler.removeCallbacksAndMessages(null);
                }
            });
        }
    }
}

