/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.text.TextUtils;
import java.io.File;
import java.util.List;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;
import org.wlf.filedownloader.util.CollectionUtil;

class RenameDownloadFileTask
implements Runnable {
    private static final String TAG = RenameDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private String mNewFileName;
    private boolean includedSuffix;
    private DownloadFileCacher mFileDownloadCacher;
    private OnRenameDownloadFileListener mOnRenameDownloadFileListener;

    RenameDownloadFileTask(String url, String newFileName, boolean includedSuffix, DownloadFileCacher fileDownloadCacher) {
        this.mUrl = url;
        this.mNewFileName = newFileName;
        this.includedSuffix = includedSuffix;
        this.mFileDownloadCacher = fileDownloadCacher;
    }

    void setOnRenameDownloadFileListener(OnRenameDownloadFileListener onRenameDownloadFileListener) {
        this.mOnRenameDownloadFileListener = onRenameDownloadFileListener;
    }

    @Override
    public void run() {
        DownloadFileInfo downloadFileInfo = this.mFileDownloadCacher.getDownloadFile(this.mUrl);
        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFilePrepared(downloadFileInfo, this.mOnRenameDownloadFileListener);
        if (downloadFileInfo != null) {
            int index;
            String dirPath = downloadFileInfo.getFileDir();
            String oldFileName = downloadFileInfo.getFileName();
            String suffix = "";
            if (oldFileName != null && oldFileName.contains(".") && (index = oldFileName.lastIndexOf(".")) != -1) {
                suffix = oldFileName.substring(index, oldFileName.length());
            }
            if (!this.includedSuffix) {
                this.mNewFileName = this.mNewFileName + suffix;
            }
            File file = new File(dirPath, oldFileName);
            File newFile = new File(dirPath, this.mNewFileName);
            switch (downloadFileInfo.getStatus()) {
                case 5: {
                    try {
                        if (!file.exists()) {
                            throw new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the original file not exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST);
                        }
                        if (TextUtils.isEmpty((CharSequence)this.mNewFileName)) {
                            throw new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("new file name is empty!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_NEW_FILE_NAME_IS_EMPTY);
                        }
                        if (this.checkNewFileExist(newFile)) {
                            throw new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the new file has been exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_NEW_FILE_HAS_BEEN_EXIST);
                        }
                        boolean isSucceed = file.renameTo(newFile);
                        if (!isSucceed) {
                            throw new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("rename file failed!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_UNKNOWN);
                        }
                        downloadFileInfo.setFileName(this.mNewFileName);
                        boolean updateResult = this.mFileDownloadCacher.updateDownloadFile(downloadFileInfo);
                        if (updateResult) {
                            OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileSuccess(downloadFileInfo, this.mOnRenameDownloadFileListener);
                            return;
                        }
                        throw new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("rename file failed!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_UNKNOWN);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        OnRenameDownloadFileListener.OnRenameDownloadFileFailReason failReason = null;
                        failReason = e instanceof OnRenameDownloadFileListener.OnRenameDownloadFileFailReason ? (OnRenameDownloadFileListener.OnRenameDownloadFileFailReason)e : new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason(e);
                        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, failReason, this.mOnRenameDownloadFileListener);
                        break;
                    }
                }
                case 6: {
                    if (this.checkNewFileExist(newFile)) {
                        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the new file has been exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_NEW_FILE_HAS_BEEN_EXIST), this.mOnRenameDownloadFileListener);
                        return;
                    }
                    downloadFileInfo.setFileName(this.mNewFileName);
                    boolean updateResult = this.mFileDownloadCacher.updateDownloadFile(downloadFileInfo);
                    if (updateResult) {
                        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileSuccess(downloadFileInfo, this.mOnRenameDownloadFileListener);
                        return;
                    }
                    OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("rename file failed!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_UNKNOWN), this.mOnRenameDownloadFileListener);
                    break;
                }
                default: {
                    OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("DownloadFile status error!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_STATUS_ERROR), this.mOnRenameDownloadFileListener);
                    return;
                }
            }
        } else {
            OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the download file is not exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST), this.mOnRenameDownloadFileListener);
        }
    }

    private boolean checkNewFileExist(File newFile) {
        if (newFile != null && newFile.exists()) {
            return true;
        }
        List<DownloadFileInfo> downloadFileInfos = this.mFileDownloadCacher.getDownloadFiles();
        if (!CollectionUtil.isEmpty(downloadFileInfos)) {
            for (DownloadFileInfo info : downloadFileInfos) {
                String path;
                if (info == null || TextUtils.isEmpty((CharSequence)(path = info.getFilePath())) || !path.equals(newFile.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }
}

