/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.wlf.filedownloader.DetectUrlFileCacher;
import org.wlf.filedownloader.DetectUrlFileInfo;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.helper.HttpConnectionHelper;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.util.UrlUtil;

class DetectUrlFileTask
implements Runnable {
    private static final String TAG = DetectUrlFileTask.class.getSimpleName();
    private static final int MAX_REDIRECT_COUNT = 5;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String CHARSET = "UTF-8";
    private String mUrl;
    private String mDownloadSaveDir;
    private DetectUrlFileCacher mDetectUrlFileCacher;
    private DownloadFileCacher mDownloadFileCacher;
    private OnDetectUrlFileListener mOnDetectUrlFileListener;

    DetectUrlFileTask(String url, String downloadSaveDir, DetectUrlFileCacher detectUrlFileCacher, DownloadFileCacher downloadFileCacher) {
        this.mUrl = url;
        this.mDownloadSaveDir = downloadSaveDir;
        this.mDetectUrlFileCacher = detectUrlFileCacher;
        this.mDownloadFileCacher = downloadFileCacher;
    }

    void setOnDetectUrlFileListener(OnDetectUrlFileListener onDetectUrlFileListener) {
        this.mOnDetectUrlFileListener = onDetectUrlFileListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        OnDetectUrlFileListener.DetectUrlFileFailReason failReason = null;
        try {
            int redirectCount;
            if (!UrlUtil.isUrl(this.mUrl)) {
                failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("url illegal!", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_URL_ILLEGAL);
                return;
            }
            DownloadFileInfo downloadFileInfo = this.mDownloadFileCacher.getDownloadFile(this.mUrl);
            if (downloadFileInfo != null) {
                if (this.mOnDetectUrlFileListener == null) return;
                OnDetectUrlFileListener.MainThreadHelper.onDetectUrlFileExist(this.mUrl, this.mOnDetectUrlFileListener);
                return;
            }
            conn = HttpConnectionHelper.createDetectConnection(this.mUrl, 15000, CHARSET);
            for (redirectCount = 0; conn.getResponseCode() / 100 == 3 && redirectCount < 5; ++redirectCount) {
                conn = HttpConnectionHelper.createDetectConnection(this.mUrl, 15000, CHARSET);
            }
            Log.d((String)TAG, (String)("DetectUrlFileTask.run \u63a2\u6d4b\u6587\u4ef6\uff0c\u91cd\u5b9a\u5411\uff1a" + redirectCount + "\u6b21" + "\uff0c\u6700\u5927\u91cd\u5b9a\u5411\u6b21\u6570\uff1a" + 5 + "\uff0curl\uff1a" + this.mUrl));
            if (redirectCount > 5) {
                failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("over max redirect:5!", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_URL_OVER_REDIRECT_COUNT);
                return;
            }
            switch (conn.getResponseCode()) {
                case 200: {
                    String fileName = UrlUtil.getFileNameByUrl(this.mUrl);
                    int fileSize = conn.getContentLength();
                    String eTag = conn.getHeaderField("ETag");
                    String acceptRangeType = conn.getHeaderField("Accept-Ranges");
                    DetectUrlFileInfo detectUrlFileInfo = new DetectUrlFileInfo(this.mUrl, fileSize, eTag, acceptRangeType, this.mDownloadSaveDir, fileName);
                    this.mDetectUrlFileCacher.addOrUpdateDetectUrlFile(detectUrlFileInfo);
                    if (this.mOnDetectUrlFileListener == null) return;
                    OnDetectUrlFileListener.MainThreadHelper.onDetectNewDownloadFile(this.mUrl, fileName, this.mDownloadSaveDir, fileSize, this.mOnDetectUrlFileListener);
                    return;
                }
                case 404: {
                    failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("url file does not exist!", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_HTTP_FILE_NOT_EXIST);
                    return;
                }
                default: {
                    failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason("ResponseCode:" + conn.getResponseCode() + " " + "error,can not read data!", OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_BAD_HTTP_RESPONSE_CODE);
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            failReason = new OnDetectUrlFileListener.DetectUrlFileFailReason(e);
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
            if (failReason != null && this.mOnDetectUrlFileListener != null) {
                OnDetectUrlFileListener.MainThreadHelper.onDetectUrlFileFailed(this.mUrl, failReason, this.mOnDetectUrlFileListener);
            }
        }
    }
}

