/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.util.List;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloadManager;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;

public final class FileDownloader {
    private static FileDownloadConfiguration sConfiguration;

    private static FileDownloadManager getFileDownloadManager() {
        if (FileDownloadManager.getConfiguration() != null && sConfiguration == null) {
            sConfiguration = FileDownloadManager.getConfiguration();
        }
        if (sConfiguration == null) {
            throw new IllegalStateException("please init the file-downloader by using " + FileDownloader.class.getSimpleName() + " or " + FileDownloadManager.class.getSimpleName() + " if the version is below" + " 0.2.0");
        }
        return FileDownloadManager.getInstance(sConfiguration.getContext());
    }

    public static void init(FileDownloadConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        sConfiguration = configuration;
        FileDownloader.getFileDownloadManager().init(configuration);
    }

    public static boolean isInit() {
        return FileDownloader.getFileDownloadManager().isInit();
    }

    public static DownloadFileInfo getDownloadFile(String url) {
        return FileDownloader.getFileDownloadManager().getDownloadFile(url);
    }

    public static DownloadFileInfo getDownloadFileBySavePath(String savePath) {
        return FileDownloader.getFileDownloadManager().getDownloadFileBySavePath(savePath);
    }

    public static DownloadFileInfo getDownloadFileByTempPath(String tempPath) {
        return FileDownloader.getFileDownloadManager().getDownloadFileByTempPath(tempPath);
    }

    public static List<DownloadFileInfo> getDownloadFiles() {
        return FileDownloader.getFileDownloadManager().getDownloadFiles();
    }

    public static String getDownloadDir() {
        return FileDownloader.getFileDownloadManager().getDownloadDir();
    }

    public static void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        FileDownloader.getFileDownloadManager().registerDownloadStatusListener(onFileDownloadStatusListener);
    }

    public static void unregisterDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        FileDownloader.getFileDownloadManager().unregisterDownloadStatusListener(onFileDownloadStatusListener);
    }

    public static void registerDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        FileDownloader.getFileDownloadManager().registerDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    public static void unregisterDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        FileDownloader.getFileDownloadManager().unregisterDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    public static void detect(String url, OnDetectUrlFileListener onDetectUrlFileListener) {
        FileDownloader.getFileDownloadManager().detect(url, onDetectUrlFileListener);
    }

    public static void createAndStart(String url, String saveDir, String fileName) {
        FileDownloader.getFileDownloadManager().createAndStart(url, saveDir, fileName);
    }

    public static void start(String url) {
        FileDownloader.getFileDownloadManager().start(url);
    }

    public static void start(List<String> urls) {
        FileDownloader.getFileDownloadManager().start(urls);
    }

    public static void pause(String url) {
        FileDownloader.getFileDownloadManager().pause(url);
    }

    public static void pause(List<String> urls) {
        FileDownloader.getFileDownloadManager().pause(urls);
    }

    public static void pauseAll() {
        FileDownloader.getFileDownloadManager().pauseAll();
    }

    public static void reStart(String url) {
        FileDownloader.getFileDownloadManager().reStart(url);
    }

    public static void reStart(List<String> urls) {
        FileDownloader.getFileDownloadManager().reStart(urls);
    }

    public static void move(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        FileDownloader.getFileDownloadManager().move(url, newDirPath, onMoveDownloadFileListener);
    }

    public static Control move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        return FileDownloader.getFileDownloadManager().move(urls, newDirPath, onMoveDownloadFilesListener);
    }

    public static void delete(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        FileDownloader.getFileDownloadManager().delete(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
    }

    public static Control delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        return FileDownloader.getFileDownloadManager().delete(urls, deleteDownloadedFile, onDeleteDownloadFilesListener);
    }

    public static void rename(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        FileDownloader.getFileDownloadManager().rename(url, newFileName, includedSuffix, onRenameDownloadFileListener);
    }

    public static void release() {
        FileDownloader.getFileDownloadManager().release();
        sConfiguration = null;
    }
}

