/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.Context;
import android.util.Log;
import java.util.List;
import org.wlf.filedownloader.DownloadDeleteManager;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadMoveManager;
import org.wlf.filedownloader.DownloadRenameManager;
import org.wlf.filedownloader.DownloadTaskManager;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloader;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;
import org.wlf.filedownloader.util.CollectionUtil;

@Deprecated
public final class FileDownloadManager {
    private static final String TAG = FileDownloadManager.class.getSimpleName();
    private static FileDownloadManager sInstance;
    private Object mInitLock = new Object();
    private FileDownloadConfiguration mConfiguration;
    private DownloadFileCacher mDownloadFileCacher;
    private DownloadTaskManager mDownloadTaskManager;
    private DownloadMoveManager mDownloadMoveManager;
    private DownloadDeleteManager mDownloadDeleteManager;
    private DownloadRenameManager mDownloadRenameManager;

    private FileDownloadManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mDownloadFileCacher = new DownloadFileCacher(appContext);
        this.exceptionStateRecovery(this.getDownloadFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileDownloadManager getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<FileDownloadManager> clazz = FileDownloadManager.class;
        synchronized (FileDownloadManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FileDownloadManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    static FileDownloadConfiguration getConfiguration() {
        if (sInstance != null) {
            return FileDownloadManager.sInstance.mConfiguration;
        }
        return null;
    }

    private void exceptionStateRecovery(List<DownloadFileInfo> downloadFileInfos) {
        Log.i((String)TAG, (String)"exceptionStateRecovery \u5f02\u5e38\u6062\u590d\u68c0\u67e5\uff01");
        if (CollectionUtil.isEmpty(downloadFileInfos)) {
            return;
        }
        block8: for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
            if (downloadFileInfo == null) continue;
            String url = downloadFileInfo.getUrl();
            if (this.isInit() && this.getDownloadTaskManager().isInFileDownloadTaskMap(url)) continue;
            switch (downloadFileInfo.getStatus()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    try {
                        this.mDownloadFileCacher.recordStatus(url, 6, 0);
                    }
                    catch (DownloadFileCacher.DownloadStatusRecordException e) {
                        e.printStackTrace();
                    }
                    continue block8;
                }
                case 5: 
                case 6: 
                case 7: {
                    continue block8;
                }
            }
            try {
                this.mDownloadFileCacher.recordStatus(url, 7, 0);
            }
            catch (DownloadFileCacher.DownloadStatusRecordException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FileDownloadConfiguration configuration) {
        Object object = this.mInitLock;
        synchronized (object) {
            this.mConfiguration = configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInit() {
        Object object = this.mInitLock;
        synchronized (object) {
            return this.mConfiguration != null;
        }
    }

    private void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("please init the file-downloader by using " + FileDownloader.class.getSimpleName() + " or " + FileDownloadManager.class.getSimpleName() + " if the version is below" + " 0.2.0");
        }
    }

    private DownloadTaskManager getDownloadTaskManager() {
        this.checkInit();
        if (this.mDownloadTaskManager == null) {
            this.mDownloadTaskManager = new DownloadTaskManager(this.mConfiguration, this.mDownloadFileCacher);
        }
        return this.mDownloadTaskManager;
    }

    private DownloadMoveManager getDownloadMoveManager() {
        this.checkInit();
        if (this.mDownloadMoveManager == null) {
            this.mDownloadMoveManager = new DownloadMoveManager(this.mConfiguration.getSupportEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadMoveManager;
    }

    private DownloadDeleteManager getDownloadDeleteManager() {
        this.checkInit();
        if (this.mDownloadDeleteManager == null) {
            this.mDownloadDeleteManager = new DownloadDeleteManager(this.mConfiguration.getSupportEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadDeleteManager;
    }

    private DownloadRenameManager getDownloadRenameManager() {
        this.checkInit();
        if (this.mDownloadRenameManager == null) {
            this.mDownloadRenameManager = new DownloadRenameManager(this.mConfiguration.getSupportEngine(), this.mDownloadFileCacher, this.getDownloadTaskManager());
        }
        return this.mDownloadRenameManager;
    }

    public DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    @Deprecated
    public DownloadFileInfo getDownloadFileByUrl(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    public DownloadFileInfo getDownloadFileBySavePath(String savePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, false);
    }

    public DownloadFileInfo getDownloadFileByTempPath(String tempPath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(tempPath, true);
    }

    @Deprecated
    public DownloadFileInfo getDownloadFileBySavePath(String savePath, boolean includeTempFilePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, includeTempFilePath);
    }

    public List<DownloadFileInfo> getDownloadFiles() {
        return this.mDownloadFileCacher.getDownloadFiles();
    }

    public String getDownloadDir() {
        this.checkInit();
        return this.mConfiguration.getFileDownloadDir();
    }

    public void registerDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().registerDownloadStatusListener(onFileDownloadStatusListener);
    }

    public void unregisterDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().unregisterDownloadStatusListener(onFileDownloadStatusListener);
    }

    public void registerDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileCacher.registerDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    public void unregisterDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileCacher.unregisterDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    public void detect(String url, OnDetectUrlFileListener onDetectUrlFileListener) {
        this.getDownloadTaskManager().detect(url, onDetectUrlFileListener);
    }

    public void createAndStart(String url, String saveDir, String fileName) {
        this.getDownloadTaskManager().createAndStart(url, saveDir, fileName);
    }

    @Deprecated
    public void createAndStart(String url, String saveDir, String fileName, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().createAndStart(url, saveDir, fileName, onFileDownloadStatusListener);
    }

    public void start(String url) {
        this.getDownloadTaskManager().start(url);
    }

    @Deprecated
    public void start(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().start(url, onFileDownloadStatusListener);
    }

    public void start(List<String> urls) {
        this.getDownloadTaskManager().start(urls);
    }

    @Deprecated
    public void start(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().start(urls, onFileDownloadStatusListener);
    }

    public void pause(String url) {
        this.getDownloadTaskManager().pause(url, null);
    }

    public void pause(List<String> urls) {
        this.getDownloadTaskManager().pause(urls, null);
    }

    public void pauseAll() {
        this.getDownloadTaskManager().pauseAll(null, null);
    }

    public void reStart(String url) {
        this.getDownloadTaskManager().reStart(url);
    }

    @Deprecated
    public void reStart(String url, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().reStart(url, onFileDownloadStatusListener);
    }

    public void reStart(List<String> urls) {
        this.getDownloadTaskManager().reStart(urls);
    }

    @Deprecated
    public void reStart(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.getDownloadTaskManager().reStart(urls, onFileDownloadStatusListener);
    }

    public void move(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.getDownloadMoveManager().move(url, newDirPath, onMoveDownloadFileListener);
    }

    public Control move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        return this.getDownloadMoveManager().move(urls, newDirPath, onMoveDownloadFilesListener);
    }

    public void delete(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        this.getDownloadDeleteManager().delete(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
    }

    public Control delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        return this.getDownloadDeleteManager().delete(urls, deleteDownloadedFile, onDeleteDownloadFilesListener);
    }

    public void rename(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        this.getDownloadRenameManager().rename(url, newFileName, includedSuffix, onRenameDownloadFileListener);
    }

    public void release() {
        this.getDownloadTaskManager().release(new DownloadTaskManager.OnReleaseListener(){

            @Override
            public void onReleased() {
                FileDownloadManager.this.mDownloadFileCacher.release();
                sInstance = null;
            }
        });
    }
}

