/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;

class DownloadFileStatusObserver
implements OnFileDownloadStatusListener {
    private Set<WeakReference<OnFileDownloadStatusListener>> mWeakOnFileDownloadStatusListeners = new HashSet<WeakReference<OnFileDownloadStatusListener>>();

    DownloadFileStatusObserver() {
    }

    void addOnFileDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener != onFileDownloadStatusListener) continue;
            return;
        }
        WeakReference<OnFileDownloadStatusListener> weakReference = new WeakReference<OnFileDownloadStatusListener>(onFileDownloadStatusListener);
        this.mWeakOnFileDownloadStatusListeners.add(weakReference);
    }

    void removeOnFileDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener != onFileDownloadStatusListener) continue;
            this.mWeakOnFileDownloadStatusListeners.remove(weakListener);
            break;
        }
    }

    void release() {
        this.mWeakOnFileDownloadStatusListeners.clear();
    }

    @Override
    public void onFileDownloadStatusWaiting(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusWaiting(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusPreparing(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusPreparing(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusPrepared(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusPrepared(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusDownloading(DownloadFileInfo downloadFileInfo, float downloadSpeed, long remainingTime) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime);
        }
    }

    @Override
    public void onFileDownloadStatusPaused(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusPaused(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusCompleted(DownloadFileInfo downloadFileInfo) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusCompleted(downloadFileInfo);
        }
    }

    @Override
    public void onFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason) {
        for (WeakReference<OnFileDownloadStatusListener> weakReference : this.mWeakOnFileDownloadStatusListeners) {
            OnFileDownloadStatusListener weakListener;
            if (weakReference == null || (weakListener = (OnFileDownloadStatusListener)weakReference.get()) == null || weakListener == this) continue;
            weakListener.onFileDownloadStatusFailed(url, downloadFileInfo, failReason);
        }
    }
}

