/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wlf.filedownloader.DownloadFileChangeObserver;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailException;
import org.wlf.filedownloader.db.ContentDbDao;
import org.wlf.filedownloader.db_recoder.DownloadFileDbHelper;
import org.wlf.filedownloader.db_recoder.DownloadFileDbRecorder;
import org.wlf.filedownloader.listener.OnDownloadFileChangeListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.ContentValuesUtil;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.MapUtil;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadFileCacher
extends DownloadFileDbRecorder {
    private static final String TAG = DownloadFileCacher.class.getSimpleName();
    private DownloadFileDbHelper mDownloadFileDbHelper;
    private Map<String, DownloadFileInfo> mDownloadFileInfoMap = new HashMap<String, DownloadFileInfo>();
    private Object mModifyLock = new Object();
    private DownloadFileChangeObserver mDownloadFileChangeObserver;

    DownloadFileCacher(Context context) {
        this.mDownloadFileDbHelper = new DownloadFileDbHelper(context);
        this.mDownloadFileChangeObserver = new DownloadFileChangeObserver();
        this.initDownloadFileInfoMapFromDb();
    }

    void registerDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileChangeObserver.addOnDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    void unregisterDownloadFileChangeListener(OnDownloadFileChangeListener onDownloadFileChangeListener) {
        this.mDownloadFileChangeObserver.removeOnDownloadFileChangeListener(onDownloadFileChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordStatus(String url, int status, int increaseSize) throws DownloadStatusRecordException {
        Log.d((String)TAG, (String)("recordStatus \u8bb0\u5f55\u72b6\u6001\uff1astatus\uff1a" + status + "\uff0cincreaseSize\uff1a" + increaseSize + "\uff0curl\uff1a" + url));
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            Object object = this.mModifyLock;
            synchronized (object) {
                if (increaseSize > 0) {
                    downloadFileInfo.setDownloadedSize(downloadFileInfo.getDownloadedSize() + increaseSize);
                }
                downloadFileInfo.setStatus(status);
                this.updateDownloadFileInternal(downloadFileInfo, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDownloadFile(DownloadFileInfo downloadFileInfo) {
        if (downloadFileInfo == null) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        ContentValues values = downloadFileInfo.getContentValues();
        if (ContentValuesUtil.isEmpty(values)) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        Object object = this.mModifyLock;
        synchronized (object) {
            long id = dao.insert(values);
            if (id != -1L) {
                downloadFileInfo.setId(new Integer((int)id));
                this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                if (this.mDownloadFileChangeObserver != null) {
                    this.mDownloadFileChangeObserver.onDownloadFileCreated(downloadFileInfo);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDownloadFileInternal(DownloadFileInfo downloadFileInfo, boolean lockInternal) {
        if (downloadFileInfo == null) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        ContentValues values = downloadFileInfo.getContentValues();
        if (ContentValuesUtil.isEmpty(values)) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        if (lockInternal) {
            Object object = this.mModifyLock;
            synchronized (object) {
                int result = dao.update(values, "_id= ?", new String[]{downloadFileInfo.getId() + ""});
                if (result == 1) {
                    if (this.mDownloadFileInfoMap.containsKey(url)) {
                        DownloadFileInfo downloadFileInfoInMap = this.mDownloadFileInfoMap.get(url);
                        downloadFileInfoInMap.update(downloadFileInfo);
                    } else {
                        this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                    }
                    if (this.mDownloadFileChangeObserver != null) {
                        this.mDownloadFileChangeObserver.onDownloadFileUpdated(downloadFileInfo, OnDownloadFileChangeListener.Type.OTHER);
                    }
                    return true;
                }
            }
        } else {
            int result = dao.update(values, "_id= ?", new String[]{downloadFileInfo.getId() + ""});
            if (result == 1) {
                if (this.mDownloadFileInfoMap.containsKey(url)) {
                    DownloadFileInfo downloadFileInfoInMap = this.mDownloadFileInfoMap.get(url);
                    downloadFileInfoInMap.update(downloadFileInfo);
                } else {
                    this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                }
                if (this.mDownloadFileChangeObserver != null) {
                    this.mDownloadFileChangeObserver.onDownloadFileUpdated(downloadFileInfo, OnDownloadFileChangeListener.Type.OTHER);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateDownloadFile(DownloadFileInfo downloadFileInfo) {
        return this.updateDownloadFileInternal(downloadFileInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDownloadFile(DownloadFileInfo downloadFileInfo) {
        if (downloadFileInfo == null) {
            return false;
        }
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return false;
        }
        String url = downloadFileInfo.getUrl();
        Object object = this.mModifyLock;
        synchronized (object) {
            int result = dao.delete("_id= ?", new String[]{downloadFileInfo.getId() + ""});
            if (result == 1) {
                this.mDownloadFileInfoMap.remove(url);
                if (this.mDownloadFileChangeObserver != null) {
                    this.mDownloadFileChangeObserver.onDownloadFileDeleted(downloadFileInfo);
                }
                return true;
            }
            result = dao.delete("url= ?", new String[]{url + ""});
            if (result == 1) {
                this.mDownloadFileInfoMap.remove(url);
                if (this.mDownloadFileChangeObserver != null) {
                    this.mDownloadFileChangeObserver.onDownloadFileDeleted(downloadFileInfo);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadFileInfo getDownloadFile(String url) {
        DownloadFileInfo downloadFileInfo = null;
        if (this.mDownloadFileInfoMap.get(url) != null) {
            downloadFileInfo = this.mDownloadFileInfoMap.get(url);
        } else {
            ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
            if (dao == null) {
                return null;
            }
            Cursor cursor = dao.query(null, "url= ?", new String[]{url}, null);
            if (cursor != null && cursor.moveToFirst()) {
                downloadFileInfo = new DownloadFileInfo(cursor);
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            if (downloadFileInfo == null) {
                return null;
            }
            String downloadUrl = downloadFileInfo.getUrl();
            if (UrlUtil.isUrl(downloadUrl)) {
                Object object = this.mModifyLock;
                synchronized (object) {
                    this.mDownloadFileInfoMap.put(downloadUrl, downloadFileInfo);
                    downloadFileInfo = this.mDownloadFileInfoMap.get(url);
                }
            }
        }
        this.checkFileStatus(downloadFileInfo);
        return downloadFileInfo;
    }

    @Override
    public List<DownloadFileInfo> getDownloadFiles() {
        if (MapUtil.isEmpty(this.mDownloadFileInfoMap)) {
            this.initDownloadFileInfoMapFromDb();
        }
        if (!MapUtil.isEmpty(this.mDownloadFileInfoMap)) {
            ArrayList<DownloadFileInfo> downloadFileInfos = new ArrayList<DownloadFileInfo>(this.mDownloadFileInfoMap.values());
            if (!CollectionUtil.isEmpty(downloadFileInfos)) {
                for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
                    this.checkFileStatus(downloadFileInfo);
                }
            }
            return downloadFileInfos;
        }
        return new ArrayList<DownloadFileInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownloadFileInfo getDownloadFileBySavePath(String savePath, boolean includeTempFilePath) {
        if (!FileUtil.isFilePath(savePath)) {
            return null;
        }
        DownloadFileInfo downloadFileInfo = null;
        Set<Map.Entry<String, DownloadFileInfo>> set = this.mDownloadFileInfoMap.entrySet();
        for (Map.Entry<String, DownloadFileInfo> entry : set) {
            String filePath;
            DownloadFileInfo info;
            if (entry == null || (info = entry.getValue()) == null || TextUtils.isEmpty((CharSequence)(filePath = info.getFilePath())) || !filePath.equals(savePath)) continue;
            downloadFileInfo = info;
            break;
        }
        if (downloadFileInfo == null) {
            String fileSaveName;
            ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
            if (dao == null) {
                return null;
            }
            int separatorIndex = savePath.lastIndexOf(File.separator);
            if (separatorIndex == -1) {
                return null;
            }
            String fileSaveDir = savePath.substring(0, separatorIndex);
            Cursor cursor = dao.query(null, "file_dir= ? AND file_name= ?", new String[]{fileSaveDir, fileSaveName = savePath.substring(separatorIndex + 1, savePath.length())}, null);
            if (cursor != null && cursor.moveToFirst()) {
                downloadFileInfo = new DownloadFileInfo(cursor);
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            if (downloadFileInfo == null && includeTempFilePath) {
                cursor = dao.query(null, "file_dir= ? AND temp_file_name= ?", new String[]{fileSaveDir, fileSaveName}, null);
                if (cursor != null && cursor.moveToFirst()) {
                    downloadFileInfo = new DownloadFileInfo(cursor);
                }
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
            if (downloadFileInfo == null) {
                return null;
            }
            String url = downloadFileInfo.getUrl();
            if (UrlUtil.isUrl(url)) {
                Object object = this.mModifyLock;
                synchronized (object) {
                    this.mDownloadFileInfoMap.put(url, downloadFileInfo);
                    downloadFileInfo = this.mDownloadFileInfoMap.get(url);
                }
            }
        }
        this.checkFileStatus(downloadFileInfo);
        return downloadFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDownloadFileInfoMapFromDb() {
        ContentDbDao dao = this.mDownloadFileDbHelper.getContentDbDao("tb_download_file");
        if (dao == null) {
            return;
        }
        Cursor cursor = dao.query(null, null, null, null);
        List<DownloadFileInfo> downloadFileInfos = this.getDownloadFileInfosFromCursor(cursor);
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        if (CollectionUtil.isEmpty(downloadFileInfos)) {
            return;
        }
        for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
            if (downloadFileInfo == null) continue;
            Object object = this.mModifyLock;
            synchronized (object) {
                this.mDownloadFileInfoMap.put(downloadFileInfo.getUrl(), downloadFileInfo);
            }
        }
    }

    private List<DownloadFileInfo> getDownloadFileInfosFromCursor(Cursor cursor) {
        ArrayList<DownloadFileInfo> downloadFileInfos = new ArrayList<DownloadFileInfo>();
        while (cursor != null && cursor.moveToNext()) {
            DownloadFileInfo downloadFileInfo = new DownloadFileInfo(cursor);
            if (downloadFileInfo == null) continue;
            downloadFileInfos.add(downloadFileInfo);
        }
        return downloadFileInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.mModifyLock;
        synchronized (object) {
            this.mDownloadFileInfoMap.clear();
            if (this.mDownloadFileDbHelper != null) {
                this.mDownloadFileDbHelper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStatus(DownloadFileInfo downloadFileInfo) {
        File file;
        if (downloadFileInfo == null) {
            return;
        }
        String filePath = null;
        switch (downloadFileInfo.getStatus()) {
            case 5: {
                filePath = downloadFileInfo.getFilePath();
                break;
            }
            case 6: {
                filePath = downloadFileInfo.getTempFilePath();
            }
        }
        if (!TextUtils.isEmpty(filePath) && !(file = new File(filePath)).exists() && downloadFileInfo.getDownloadedSize() > 0) {
            Object object = this.mModifyLock;
            synchronized (object) {
                downloadFileInfo.setStatus(8);
                this.updateDownloadFileInternal(downloadFileInfo, false);
            }
        }
    }

    static class DownloadStatusRecordException
    extends FailException {
        private static final long serialVersionUID = 2729490220280837606L;

        public DownloadStatusRecordException(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public DownloadStatusRecordException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }
}

