/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DeleteDownloadFileTask;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.DownloadTaskManager;
import org.wlf.filedownloader.FileDownloadTask;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.util.UrlUtil;

class DownloadDeleteManager {
    private static final String TAG = DownloadDeleteManager.class.getSimpleName();
    private ExecutorService mSupportEngine;
    private DownloadFileCacher mDownloadFileCacher;
    private DownloadTaskManager mDownloadTaskManager;
    private DeleteDownloadFilesTask mDeleteDownloadFilesTask;

    DownloadDeleteManager(ExecutorService supportEngine, DownloadFileCacher downloadFileCacher, DownloadTaskManager downloadTaskManager) {
        this.mSupportEngine = supportEngine;
        this.mDownloadFileCacher = downloadFileCacher;
        this.mDownloadTaskManager = downloadTaskManager;
    }

    private void addAndRunTask(Runnable task) {
        this.mSupportEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    private void deleteInternal(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        DeleteDownloadFileTask deleteDownloadFileTask = new DeleteDownloadFileTask(url, deleteDownloadedFileInPath, this.mDownloadFileCacher);
        deleteDownloadFileTask.setOnDeleteDownloadFileListener(onDeleteDownloadFileListener);
        this.addAndRunTask(deleteDownloadFileTask);
    }

    void delete(String url, final boolean deleteDownloadedFileInPath, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("delete \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onDeleteDownloadFileListener != null) {
                onDeleteDownloadFileListener.onDeleteDownloadFileFailed(downloadFileInfo, new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason("the download file doest not exist!", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST));
            }
            return;
        }
        if (!this.mDownloadTaskManager.isInFileDownloadTaskMap(url)) {
            Log.d((String)TAG, (String)("delete \u76f4\u63a5\u5220\u9664,url:" + url));
            this.deleteInternal(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
        } else {
            Log.d((String)TAG, (String)("delete \u9700\u8981\u5148\u6682\u505c\u540e\u5220\u9664,url:" + url));
            this.mDownloadTaskManager.pause(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("delete \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u5220\u9664,url:" + url));
                    DownloadDeleteManager.this.deleteInternal(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("delete \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u5220\u9664,url:" + url));
                    if (onDeleteDownloadFileListener != null) {
                        OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileFailed(downloadFileInfo, new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(failReason), onDeleteDownloadFileListener);
                    }
                }
            });
        }
    }

    Control delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        if (this.mDeleteDownloadFilesTask != null && !this.mDeleteDownloadFilesTask.isStopped()) {
            return new DeleteControl(this.mDeleteDownloadFilesTask);
        }
        DeleteDownloadFilesTask deleteDownloadFilesTask = new DeleteDownloadFilesTask(urls, deleteDownloadedFile);
        deleteDownloadFilesTask.setOnDeleteDownloadFilesListener(onDeleteDownloadFilesListener);
        this.addAndRunTask(deleteDownloadFilesTask);
        this.mDeleteDownloadFilesTask = deleteDownloadFilesTask;
        return new DeleteControl(this.mDeleteDownloadFilesTask);
    }

    static class DeleteControl
    implements Control {
        private DeleteDownloadFilesTask mDeleteDownloadFilesTask;

        private DeleteControl(DeleteDownloadFilesTask deleteDownloadFilesTask) {
            this.mDeleteDownloadFilesTask = deleteDownloadFilesTask;
        }

        @Override
        public void stop() {
            if (this.mDeleteDownloadFilesTask != null) {
                this.mDeleteDownloadFilesTask.stop();
            }
        }

        @Override
        public boolean isStopped() {
            if (this.mDeleteDownloadFilesTask == null) {
                return true;
            }
            return this.mDeleteDownloadFilesTask.isStopped();
        }
    }

    private class DeleteDownloadFilesTask
    implements Runnable,
    Stoppable {
        private List<String> mUrls;
        private boolean mDeleteDownloadedFile;
        private OnDeleteDownloadFilesListener mOnDeleteDownloadFilesListener;
        private boolean mIsStop = false;
        private boolean mCompleted = false;
        private final List<DownloadFileInfo> mDownloadFilesNeedDelete = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesDeleted = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

        public DeleteDownloadFilesTask(List<String> urls, boolean deleteDownloadedFile) {
            this.mUrls = urls;
            this.mDeleteDownloadedFile = deleteDownloadedFile;
        }

        public void setOnDeleteDownloadFilesListener(OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
            this.mOnDeleteDownloadFilesListener = onDeleteDownloadFilesListener;
        }

        @Override
        public void stop() {
            this.mIsStop = true;
        }

        @Override
        public boolean isStopped() {
            return this.mIsStop;
        }

        @Override
        public void run() {
            DownloadFileInfo downloadFileInfo;
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = DownloadDeleteManager.this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedDelete.add(downloadFileInfo);
            }
            if (this.mOnDeleteDownloadFilesListener != null) {
                Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run \u51c6\u5907\u6279\u91cf\u5220\u9664\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedDelete.size()));
                OnDeleteDownloadFilesListener.MainThreadHelper.onDeleteDownloadFilePrepared(this.mDownloadFilesNeedDelete, this.mOnDeleteDownloadFilesListener);
            }
            OnDeleteDownloadFileListener onDeleteDownloadFileListener = new OnDeleteDownloadFileListener(){
                private int deleteCount = 0;

                @Override
                public void onDeleteDownloadFilePrepared(DownloadFileInfo downloadFileNeedDelete) {
                    String url = null;
                    if (downloadFileNeedDelete != null) {
                        url = downloadFileNeedDelete.getUrl();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run \u51c6\u5907\u5220\u9664\uff0curl\uff1a" + url));
                    if (DeleteDownloadFilesTask.this.mOnDeleteDownloadFilesListener != null) {
                        DeleteDownloadFilesTask.this.mOnDeleteDownloadFilesListener.onDeletingDownloadFiles(DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete, DeleteDownloadFilesTask.this.mDownloadFilesDeleted, DeleteDownloadFilesTask.this.mDownloadFilesSkip, downloadFileNeedDelete);
                    }
                    ++this.deleteCount;
                }

                @Override
                public void onDeleteDownloadFileSuccess(DownloadFileInfo downloadFileDeleted) {
                    String url = null;
                    if (downloadFileDeleted != null) {
                        url = downloadFileDeleted.getUrl();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run onDeleteDownloadFileSuccess,\u5220\u9664\u6210\u529f\uff0cdeleteCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedDelete.size():" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0curl\uff1a" + url));
                    DeleteDownloadFilesTask.this.mDownloadFilesDeleted.add(downloadFileDeleted);
                    if (this.deleteCount == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() - DeleteDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run onDeleteDownloadFileSuccess,\u5220\u9664\u6210\u529f\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                        DeleteDownloadFilesTask.this.onDeleteDownloadFilesCompleted();
                    }
                }

                @Override
                public void onDeleteDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason failReason) {
                    String url = null;
                    if (downloadFileInfo != null) {
                        url = downloadFileInfo.getUrl();
                    }
                    String type = null;
                    if (failReason != null) {
                        type = failReason.getType();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run onDeleteDownloadFileFailed,\u5220\u9664\u5931\u8d25\uff0cdeleteCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedDelete.size():" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0curl\uff1a" + url + ",failReason:" + type));
                    DeleteDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
                    if (this.deleteCount == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() - DeleteDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run onDeleteDownloadFileFailed,\u5220\u9664\u5931\u8d25\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                        DeleteDownloadFilesTask.this.onDeleteDownloadFilesCompleted();
                    }
                }
            };
            for (int i = 0; i < this.mDownloadFilesNeedDelete.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedDelete.get(i);
                if (downloadFileInfo == null) continue;
                String url = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run task has been sopped,\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5220\u9664\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                    this.onDeleteDownloadFilesCompleted();
                }
                DownloadDeleteManager.this.delete(url, this.mDeleteDownloadedFile, onDeleteDownloadFileListener);
            }
        }

        private void onDeleteDownloadFilesCompleted() {
            if (this.mCompleted) {
                return;
            }
            if (this.mOnDeleteDownloadFilesListener != null) {
                this.mOnDeleteDownloadFilesListener.onDeleteDownloadFilesCompleted(this.mDownloadFilesNeedDelete, this.mDownloadFilesDeleted);
            }
            this.mCompleted = true;
            this.mIsStop = true;
        }
    }
}

