/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.InputStream;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.db_recoder.DownloadFileDbRecorder;
import org.wlf.filedownloader.file_saver.FileSaver;
import org.wlf.filedownloader.http_downlaoder.HttpDownloader;
import org.wlf.filedownloader.http_downlaoder.Range;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.util.FileUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class FileDownloadTask
implements Runnable,
Stoppable,
HttpDownloader.OnHttpDownloadListener,
FileSaver.OnFileSaveListener {
    private static final String TAG = FileDownloadTask.class.getSimpleName();
    private FileDownloadTaskParam mTaskParamInfo;
    private HttpDownloader mDownloader;
    private FileSaver mSaver;
    private DownloadFileDbRecorder mRecorder;
    private OnFileDownloadStatusListener mOnFileDownloadStatusListener;
    private OnStopFileDownloadTaskListener mOnStopFileDownloadTaskListener;
    private long mLastDownloadingTime = -1L;
    private boolean mIsNotifyTaskFinish;

    public FileDownloadTask(FileDownloadTaskParam taskParamInfo, DownloadFileDbRecorder recorder) {
        this.mTaskParamInfo = taskParamInfo;
        this.init();
        this.mRecorder = recorder;
        if (!this.checkTaskCanExecute()) {
            return;
        }
        this.notifyStatusWaiting();
    }

    private void init() {
        Log.i((String)TAG, (String)("init 1\u3001\u521d\u59cb\u5316\u4e0b\u8f7d\u4efb\u52a1\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
        Range range = new Range(this.mTaskParamInfo.mStartPosInTotal, this.mTaskParamInfo.mFileTotalSize);
        this.mDownloader = new HttpDownloader(this.mTaskParamInfo.mUrl, range, this.mTaskParamInfo.mAcceptRangeType, this.mTaskParamInfo.mETag);
        this.mDownloader.setOnHttpDownloadListener(this);
        this.mSaver = new FileSaver(this.mTaskParamInfo.mUrl, this.mTaskParamInfo.mTempFilePath, this.mTaskParamInfo.mFilePath, this.mTaskParamInfo.mFileTotalSize);
        this.mSaver.setOnFileSaveListener(this);
    }

    public void setOnFileDownloadStatusListener(OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.mOnFileDownloadStatusListener = onFileDownloadStatusListener;
    }

    public void setOnStopFileDownloadTaskListener(OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.mOnStopFileDownloadTaskListener = onStopFileDownloadTaskListener;
    }

    private DownloadFileInfo getDownloadFile() {
        if (this.mRecorder == null) {
            return null;
        }
        return this.mRecorder.getDownloadFile(this.mTaskParamInfo.mUrl);
    }

    public String getUrl() {
        return this.mTaskParamInfo.mUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.checkIsStop()) {
            return;
        }
        if (this.mIsNotifyTaskFinish) {
            if (!this.isStopped()) {
                this.stop();
            }
            return;
        }
        this.mLastDownloadingTime = -1L;
        Log.i((String)TAG, (String)("FileDownloadTask.run 2\u3001\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u6b63\u5728\u83b7\u53d6\u8d44\u6e90\uff0curl\uff1a\uff1a" + this.mTaskParamInfo.mUrl));
        boolean canNext = this.notifyStatusPreparing();
        if (!canNext) {
            return;
        }
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        try {
            this.mDownloader.download();
        }
        catch (HttpDownloader.HttpDownloadException e) {
            e.printStackTrace();
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e);
        }
        finally {
            if (!this.mIsNotifyTaskFinish) {
                if (failReason == null) {
                    DownloadFileInfo downloadFileInfo = this.getDownloadFile();
                    if (downloadFileInfo != null) {
                        int fileSize;
                        int downloadedSize = downloadFileInfo.getDownloadedSize();
                        if (downloadedSize == (fileSize = downloadFileInfo.getFileSize())) {
                            this.notifyTaskFinish(5, 0, null);
                        } else if (downloadedSize < fileSize) {
                            this.notifyTaskFinish(6, 0, null);
                        } else {
                            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("download size error!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_DOWNLOAD_FILE_ERROR);
                        }
                    } else {
                        failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("DownloadFile is null!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
                    }
                }
                if (failReason != null && !this.mIsNotifyTaskFinish) {
                    this.notifyTaskFinish(7, 0, failReason);
                }
            }
            Log.i((String)TAG, (String)("FileDownloadTask.run 7\u3001\u4efb\u52a1\u7ed3\u675f\u6267\u884c\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
        }
    }

    @Override
    public void onDownloadConnected(InputStream inputStream, int startPosInTotal) {
        if (this.checkIsStop()) {
            return;
        }
        if (this.mIsNotifyTaskFinish) {
            if (!this.isStopped()) {
                this.stop();
            }
            return;
        }
        Log.i((String)TAG, (String)("FileDownloadTask.run 3\u3001\u5df2\u7ecf\u8fde\u63a5\u8d44\u6e90\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
        boolean canNext = this.notifyStatusPrepared();
        if (!canNext) {
            return;
        }
        try {
            this.mSaver.saveData(inputStream, startPosInTotal);
        }
        catch (FileSaver.FileSaveException e) {
            e.printStackTrace();
            this.notifyTaskFinish(7, 0, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e));
        }
    }

    @Override
    public void onSaveDataStart() {
        if (this.checkIsStop()) {
            return;
        }
        if (this.mIsNotifyTaskFinish) {
            if (!this.isStopped()) {
                this.stop();
            }
            return;
        }
        Log.i((String)TAG, (String)("FileDownloadTask.run 4\u3001\u51c6\u5907\u4e0b\u8f7d\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
        boolean canNext = this.notifyStatusDownloading(0);
        if (!canNext) {
            return;
        }
    }

    @Override
    public void onSavingData(int increaseSize, int totalSize) {
        if (this.checkIsStop()) {
            return;
        }
        if (this.mIsNotifyTaskFinish) {
            if (!this.isStopped()) {
                this.stop();
            }
            return;
        }
        Log.i((String)TAG, (String)("FileDownloadTask.run 5\u3001\u4e0b\u8f7d\u4e2d\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
        boolean canNext = this.notifyStatusDownloading(increaseSize);
        if (!canNext) {
            return;
        }
    }

    @Override
    public void onSaveDataEnd(int increaseSize, boolean complete) {
        if (this.checkIsStop()) {
            return;
        }
        if (this.mIsNotifyTaskFinish) {
            if (!this.isStopped()) {
                this.stop();
            }
            return;
        }
        if (!complete) {
            Log.i((String)TAG, (String)("FileDownloadTask.run 6\u3001\u6682\u505c\u4e0b\u8f7d\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
            this.notifyTaskFinish(6, increaseSize, null);
        } else {
            Log.i((String)TAG, (String)("FileDownloadTask.run 6\u3001\u4e0b\u8f7d\u5b8c\u6210\uff0curl\uff1a" + this.mTaskParamInfo.mUrl));
            this.notifyTaskFinish(5, increaseSize, null);
        }
    }

    private boolean notifyStatusWaiting() {
        try {
            this.mRecorder.recordStatus(this.mTaskParamInfo.mUrl, 1, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusWaiting(this.getDownloadFile(), this.mOnFileDownloadStatusListener);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyTaskFinish(7, 0, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e));
            return false;
        }
    }

    private boolean notifyStatusPreparing() {
        try {
            this.mRecorder.recordStatus(this.mTaskParamInfo.mUrl, 2, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPreparing(this.getDownloadFile(), this.mOnFileDownloadStatusListener);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyTaskFinish(7, 0, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e));
            return false;
        }
    }

    private boolean notifyStatusPrepared() {
        try {
            this.mRecorder.recordStatus(this.mTaskParamInfo.mUrl, 3, 0);
            if (this.mOnFileDownloadStatusListener != null) {
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPrepared(this.getDownloadFile(), this.mOnFileDownloadStatusListener);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyTaskFinish(7, 0, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e));
            return false;
        }
    }

    private boolean notifyStatusDownloading(int increaseSize) {
        try {
            this.mRecorder.recordStatus(this.mTaskParamInfo.mUrl, 4, increaseSize);
            DownloadFileInfo downloadFileInfo = this.getDownloadFile();
            if (downloadFileInfo == null) {
                increaseSize = 0;
                this.notifyTaskFinish(7, increaseSize, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("DownloadFile is null!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER));
                return false;
            }
            if (this.mOnFileDownloadStatusListener != null) {
                int remainingSize;
                double downloadSpeed = 0.0;
                long remainingTime = -1L;
                long curDownloadingTime = SystemClock.elapsedRealtime();
                if (this.mLastDownloadingTime != -1L) {
                    double increaseKbs = (double)increaseSize / 1024.0;
                    double increaseSeconds = (double)(curDownloadingTime - this.mLastDownloadingTime) / 1000.0;
                    downloadSpeed = increaseKbs / increaseSeconds;
                }
                if (downloadSpeed > 0.0 && (remainingSize = downloadFileInfo.getFileSize() - downloadFileInfo.getDownloadedSize()) > 0) {
                    remainingTime = (long)((double)remainingSize / 1024.0 / downloadSpeed);
                }
                this.mLastDownloadingTime = curDownloadingTime;
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusDownloading(downloadFileInfo, (float)downloadSpeed, remainingTime, this.mOnFileDownloadStatusListener);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            increaseSize = 0;
            this.notifyTaskFinish(7, increaseSize, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTaskFinish(int status, int increaseSize, OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason) {
        switch (status) {
            case 5: 
            case 6: 
            case 7: {
                if (this.mIsNotifyTaskFinish) {
                    return;
                }
                boolean notify = false;
                try {
                    this.mRecorder.recordStatus(this.mTaskParamInfo.mUrl, status, increaseSize);
                    if (this.mOnFileDownloadStatusListener != null) {
                        switch (status) {
                            case 6: {
                                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusPaused(this.getDownloadFile(), this.mOnFileDownloadStatusListener);
                                this.notifyStopSucceed();
                                notify = true;
                                break;
                            }
                            case 5: {
                                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusCompleted(this.getDownloadFile(), this.mOnFileDownloadStatusListener);
                                this.notifyStopSucceed();
                                notify = true;
                                break;
                            }
                            case 7: {
                                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), failReason, this.mOnFileDownloadStatusListener);
                                this.notifyStopFailed(new OnStopDownloadFileTaskFailReason(failReason));
                            }
                        }
                    }
                    this.mIsNotifyTaskFinish = true;
                    if (!this.mIsNotifyTaskFinish || notify) break;
                    this.stop();
                    break;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(this.getUrl(), this.getDownloadFile(), new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e), this.mOnFileDownloadStatusListener);
                        this.mIsNotifyTaskFinish = true;
                        if (!this.mIsNotifyTaskFinish || notify) break;
                        this.stop();
                        break;
                    }
                    catch (Throwable throwable) {
                        if (this.mIsNotifyTaskFinish && !notify) {
                            this.stop();
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private void notifyStopSucceed() {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(this.mTaskParamInfo.mUrl);
        }
    }

    private void notifyStopFailed(OnStopDownloadFileTaskFailReason failReason) {
        if (this.mOnStopFileDownloadTaskListener != null) {
            this.mOnStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(this.mTaskParamInfo.mUrl, failReason);
        }
    }

    private boolean checkIsStop() {
        if (this.isStopped() && !this.mIsNotifyTaskFinish) {
            this.notifyTaskFinish(6, 0, null);
        }
        return this.isStopped();
    }

    private boolean checkTaskCanExecute() {
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (this.mTaskParamInfo == null) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("init param is null pointer!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
        }
        if (failReason == null && !UrlUtil.isUrl(this.mTaskParamInfo.mUrl)) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("url illegal!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_URL_ILLEGAL);
        }
        if (failReason == null && !FileUtil.isFilePath(this.mTaskParamInfo.mFilePath)) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("saveDir illegal!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_SAVE_PATH_ILLEGAL);
        }
        if (!(failReason != null || FileUtil.canWrite(this.mTaskParamInfo.mTempFilePath) && FileUtil.canWrite(this.mTaskParamInfo.mFilePath))) {
            failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("savePath can not write!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_STORAGE_SPACE_CAN_NOT_WRITE);
        }
        if (failReason == null) {
            try {
                File file = new File(this.mTaskParamInfo.mFilePath);
                String checkPath = !file.exists() ? file.getParentFile().getAbsolutePath() : this.mTaskParamInfo.mFilePath;
                long freeSize = FileUtil.getAvailableSpace(checkPath);
                long needDownloadSize = this.mTaskParamInfo.mFileTotalSize - this.mTaskParamInfo.mStartPosInTotal;
                if (freeSize == -1L || needDownloadSize > freeSize) {
                    failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("storage space is full!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_STORAGE_SPACE_IS_FULL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(e);
            }
        }
        if (failReason != null) {
            if (!this.mIsNotifyTaskFinish) {
                this.notifyTaskFinish(6, 0, failReason);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isStopped() {
        if (this.mSaver != null) {
            return this.mSaver.isStopped();
        }
        return true;
    }

    @Override
    public void stop() {
        if (this.isStopped()) {
            this.notifyStopFailed(new OnStopDownloadFileTaskFailReason("the task has been stopped!", OnStopDownloadFileTaskFailReason.TYPE_TASK_IS_STOPPED));
            return;
        }
        if (this.mSaver != null) {
            this.mSaver.stop();
        }
    }

    public static class OnStopDownloadFileTaskFailReason
    extends FailReason {
        private static final long serialVersionUID = 6959079784746889291L;
        public static final String TYPE_TASK_IS_STOPPED = OnStopDownloadFileTaskFailReason.class.getName() + "_TYPE_TASK_IS_STOPPED";

        public OnStopDownloadFileTaskFailReason(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public OnStopDownloadFileTaskFailReason(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }

    public static interface OnStopFileDownloadTaskListener {
        public void onStopFileDownloadTaskSucceed(String var1);

        public void onStopFileDownloadTaskFailed(String var1, OnStopDownloadFileTaskFailReason var2);
    }

    public static class FileDownloadTaskParam {
        private String mUrl;
        private int mStartPosInTotal;
        private int mFileTotalSize;
        private String mETag;
        private String mAcceptRangeType;
        private String mTempFilePath;
        private String mFilePath;

        public FileDownloadTaskParam(String url, int startPosInTotal, int fileTotalSize, String eTag, String acceptRangeType, String tempFilePath, String filePath) {
            this.mUrl = url;
            this.mStartPosInTotal = startPosInTotal;
            this.mFileTotalSize = fileTotalSize;
            this.mETag = eTag;
            this.mAcceptRangeType = acceptRangeType;
            this.mTempFilePath = tempFilePath;
            this.mFilePath = filePath;
        }
    }
}

