/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wlf.filedownloader.DeleteDownloadFileTask;
import org.wlf.filedownloader.DetectUrlFileCacher;
import org.wlf.filedownloader.DetectUrlFileInfo;
import org.wlf.filedownloader.DetectUrlFileTask;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloadTask;
import org.wlf.filedownloader.MoveDownloadFileTask;
import org.wlf.filedownloader.RenameDownloadFileTask;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.helper.FileDownloadTaskParamHelper;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;
import org.wlf.filedownloader.listener.OnDeleteDownloadFilesListener;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;
import org.wlf.filedownloader.util.CollectionUtil;
import org.wlf.filedownloader.util.UrlUtil;

public class FileDownloadManager {
    private static final String TAG = FileDownloadManager.class.getSimpleName();
    private static FileDownloadManager sInstance;
    private FileDownloadConfiguration mConfiguration;
    private DetectUrlFileCacher mDetectUrlFileCacher;
    private DownloadFileCacher mDownloadFileCacher;
    private Map<String, FileDownloadTask> mFileDownloadTaskMap = new ConcurrentHashMap<String, FileDownloadTask>();
    private DeleteDownloadFilesTask mDeleteDownloadFilesTask = null;
    private MoveDownloadFilesTask mMoveDownloadFilesTask = null;
    private Object mInitLock = new Object();

    private FileDownloadManager(Context context) {
        Context appContext = context.getApplicationContext();
        this.mDetectUrlFileCacher = new DetectUrlFileCacher();
        this.mDownloadFileCacher = new DownloadFileCacher(appContext);
        this.exceptionStateRecovery(this.getDownloadFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileDownloadManager getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<FileDownloadManager> clazz = FileDownloadManager.class;
        synchronized (FileDownloadManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new FileDownloadManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FileDownloadConfiguration configuration) {
        Object object = this.mInitLock;
        synchronized (object) {
            this.mConfiguration = configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInit() {
        Object object = this.mInitLock;
        synchronized (object) {
            return this.mConfiguration != null;
        }
    }

    private void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("please init " + FileDownloadManager.class.getSimpleName());
        }
    }

    private void exceptionStateRecovery(List<DownloadFileInfo> downloadFileInfos) {
        Log.i((String)TAG, (String)"exceptionStateRecovery \u5f02\u5e38\u6062\u590d\u68c0\u67e5\uff01");
        if (CollectionUtil.isEmpty(downloadFileInfos)) {
            return;
        }
        block8: for (DownloadFileInfo downloadFileInfo : downloadFileInfos) {
            String url;
            if (downloadFileInfo == null || this.isInFileDownloadTaskMap(url = downloadFileInfo.getUrl())) continue;
            switch (downloadFileInfo.getStatus()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    try {
                        this.mDownloadFileCacher.recordStatus(url, 6, 0);
                    }
                    catch (DownloadFileCacher.DownloadStatusRecordException e) {
                        e.printStackTrace();
                    }
                    continue block8;
                }
                case 5: 
                case 6: 
                case 7: {
                    continue block8;
                }
            }
            try {
                this.mDownloadFileCacher.recordStatus(url, 7, 0);
            }
            catch (DownloadFileCacher.DownloadStatusRecordException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isInFileDownloadTaskMap(String url) {
        return this.getFileDownloadTask(url) != null;
    }

    private FileDownloadTask getFileDownloadTask(String url) {
        DownloadFileInfo downloadFileInfo = this.mDownloadFileCacher.getDownloadFile(url);
        if (downloadFileInfo == null) {
            return this.mFileDownloadTaskMap.get(url);
        }
        switch (downloadFileInfo.getStatus()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                FileDownloadTask task = this.mFileDownloadTaskMap.get(url);
                if (task == null || task.isStopped()) break;
                return task;
            }
        }
        if (this.mFileDownloadTaskMap.containsKey(url)) {
            this.mFileDownloadTaskMap.remove(url);
        }
        return null;
    }

    private DetectUrlFileInfo getDetectUrlFile(String url) {
        return this.mDetectUrlFileCacher.getDetectUrlFile(url);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileCacher.getDownloadFile(url);
    }

    public DownloadFileInfo getDownloadFileByUrl(String url) {
        return this.getDownloadFile(url);
    }

    public DownloadFileInfo getDownloadFileBySavePath(String savePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, false);
    }

    public DownloadFileInfo getDownloadFileBySavePath(String savePath, boolean includeTempFilePath) {
        return this.mDownloadFileCacher.getDownloadFileBySavePath(savePath, includeTempFilePath);
    }

    public List<DownloadFileInfo> getDownloadFiles() {
        return this.mDownloadFileCacher.getDownloadFiles();
    }

    private void addAndRunFileDownloadTask(DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(FileDownloadTaskParamHelper.createByDownloadFile(downloadFileInfo), this.mDownloadFileCacher);
        fileDownloadTask.setOnFileDownloadStatusListener(onFileDownloadStatusListener);
        this.mFileDownloadTaskMap.put(fileDownloadTask.getUrl(), fileDownloadTask);
        this.mConfiguration.getFileDownloadEngine().execute(fileDownloadTask);
    }

    private void notifyFileDownloadStatusFailedWithCheck(String url, final OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason, final OnFileDownloadStatusListener onFileDownloadStatusListener, final boolean recordStatus) {
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            if (onFileDownloadStatusListener != null) {
                OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(url, downloadFileInfo, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), onFileDownloadStatusListener);
            }
            return;
        }
        final String downloadUrl = downloadFileInfo.getUrl();
        if (this.isInFileDownloadTaskMap(downloadUrl)) {
            FileDownloadTask fileDownloadTask = this.getFileDownloadTask(downloadUrl);
            if (fileDownloadTask != null) {
                fileDownloadTask.setOnStopFileDownloadTaskListener(new FileDownloadTask.OnStopFileDownloadTaskListener(){

                    @Override
                    public void onStopFileDownloadTaskSucceed(String url) {
                        FileDownloadManager.this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
                    }

                    @Override
                    public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason2) {
                        FileDownloadManager.this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason2), onFileDownloadStatusListener, recordStatus);
                    }
                });
                fileDownloadTask.stop();
            } else {
                this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
            }
        } else {
            this.notifyFileDownloadStatusFailed(downloadUrl, downloadFileInfo, failReason, onFileDownloadStatusListener, recordStatus);
        }
    }

    private void notifyFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason, OnFileDownloadStatusListener onFileDownloadStatusListener, boolean recordStatus) {
        if (recordStatus) {
            try {
                this.mDownloadFileCacher.recordStatus(url, 7, 0);
            }
            catch (DownloadFileCacher.DownloadStatusRecordException e) {
                e.printStackTrace();
            }
        }
        if (onFileDownloadStatusListener != null) {
            OnFileDownloadStatusListener.MainThreadHelper.onFileDownloadStatusFailed(url, downloadFileInfo, failReason, onFileDownloadStatusListener);
        }
    }

    private void onFileDownloadTaskStopped(String url) {
        this.mFileDownloadTaskMap.remove(url);
    }

    private void addAndRunSupportTask(Runnable task) {
        this.mConfiguration.getSupportEngine().execute(task);
    }

    public String getDownloadDir() {
        return this.mConfiguration.getFileDownloadDir();
    }

    public void release() {
        this.pauseAll();
        this.mDetectUrlFileCacher.release();
        this.mDownloadFileCacher.release();
        sInstance = null;
    }

    public void detect(String url, OnDetectUrlFileListener onDetectUrlFileListener) {
        this.checkInit();
        DetectUrlFileTask detectUrlFileTask = new DetectUrlFileTask(url, this.mConfiguration.getFileDownloadDir(), this.mDetectUrlFileCacher, this.mDownloadFileCacher);
        detectUrlFileTask.setOnDetectUrlFileListener(onDetectUrlFileListener);
        this.addAndRunSupportTask(detectUrlFileTask);
    }

    public void createAndStart(String url, String saveDir, String fileName, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.checkInit();
        DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
        if (detectUrlFileInfo == null) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT);
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, onFileDownloadStatusListener, false);
            return;
        }
        detectUrlFileInfo.setFileDir(saveDir);
        detectUrlFileInfo.setFileName(fileName);
        this.createAndStartByDetectUrlFile(url, detectUrlFileInfo, onFileDownloadStatusListener);
    }

    private void createAndStartByDetectUrlFile(String url, DetectUrlFileInfo detectUrlFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        if (detectUrlFileInfo == null) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("detect file does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_NOT_DETECT);
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, onFileDownloadStatusListener, false);
            return;
        }
        String downloadUrl = detectUrlFileInfo.getUrl();
        if (this.isInFileDownloadTaskMap(downloadUrl)) {
            OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the task has been in download task map!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_IS_DOWNLOADING);
            this.notifyFileDownloadStatusFailedWithCheck(downloadUrl, failReason, onFileDownloadStatusListener, false);
            return;
        }
        DownloadFileInfo downloadFileInfo = new DownloadFileInfo(detectUrlFileInfo);
        this.mDownloadFileCacher.addDownloadFile(downloadFileInfo);
        this.startInternal(downloadUrl, downloadFileInfo, onFileDownloadStatusListener);
    }

    private void startInternal(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        OnFileDownloadStatusListener.OnFileDownloadStatusFailReason failReason = null;
        if (downloadFileInfo == null) {
            if (failReason == null) {
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the downloadFileInfo does not exist!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_NULL_POINTER);
            }
        } else {
            String downloadUrl = downloadFileInfo.getUrl();
            if (failReason == null && this.isInFileDownloadTaskMap(downloadUrl)) {
                failReason = new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason("the task has been in download task map!", OnFileDownloadStatusListener.OnFileDownloadStatusFailReason.TYPE_FILE_IS_DOWNLOADING);
                url = downloadUrl;
            }
        }
        if (failReason != null) {
            this.notifyFileDownloadStatusFailedWithCheck(url, failReason, onFileDownloadStatusListener, false);
            return;
        }
        this.addAndRunFileDownloadTask(downloadFileInfo, onFileDownloadStatusListener);
    }

    public void start(String url, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
        this.checkInit();
        DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo != null) {
            this.startInternal(downloadFileInfo.getUrl(), downloadFileInfo, onFileDownloadStatusListener);
        } else {
            DetectUrlFileInfo detectUrlFileInfo = this.getDetectUrlFile(url);
            if (detectUrlFileInfo != null) {
                this.createAndStartByDetectUrlFile(detectUrlFileInfo.getUrl(), detectUrlFileInfo, onFileDownloadStatusListener);
            } else {
                this.detect(url, new OnDetectUrlFileListener(){

                    @Override
                    public void onDetectUrlFileFailed(String url, OnDetectUrlFileListener.DetectUrlFileFailReason failReason) {
                        FileDownloadManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), onFileDownloadStatusListener, false);
                    }

                    @Override
                    public void onDetectUrlFileExist(String url) {
                        FileDownloadManager.this.startInternal(url, FileDownloadManager.this.getDownloadFile(url), onFileDownloadStatusListener);
                    }

                    @Override
                    public void onDetectNewDownloadFile(String url, String fileName, String savedDir, int fileSize) {
                        FileDownloadManager.this.createAndStart(url, savedDir, fileName, onFileDownloadStatusListener);
                    }
                });
            }
        }
    }

    public void start(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.start(url, onFileDownloadStatusListener);
        }
    }

    private boolean pauseInternal(String url, final FileDownloadTask.OnStopFileDownloadTaskListener onStopFileDownloadTaskListener) {
        this.checkInit();
        FileDownloadTask fileDownloadTask = this.getFileDownloadTask(url);
        if (fileDownloadTask != null) {
            fileDownloadTask.setOnStopFileDownloadTaskListener(new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("pauseInternal \u6682\u505c\u6210\u529furl\uff1a" + url));
                    FileDownloadManager.this.onFileDownloadTaskStopped(url);
                    if (onStopFileDownloadTaskListener != null) {
                        onStopFileDownloadTaskListener.onStopFileDownloadTaskSucceed(url);
                    }
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("pauseInternal \u6682\u505c\u5931\u8d25url\uff1a" + url + ",failReason:" + failReason));
                    if (onStopFileDownloadTaskListener != null) {
                        onStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(url, failReason);
                    }
                }
            });
            fileDownloadTask.stop();
            return true;
        }
        FileDownloadTask.OnStopDownloadFileTaskFailReason failReason = new FileDownloadTask.OnStopDownloadFileTaskFailReason("the task has been paused!", FileDownloadTask.OnStopDownloadFileTaskFailReason.TYPE_TASK_IS_STOPPED);
        Log.d((String)TAG, (String)("pauseInternal \u5df2\u7ecf\u6682\u505curl\uff1a" + url + ",failReason:" + failReason));
        if (onStopFileDownloadTaskListener != null) {
            onStopFileDownloadTaskListener.onStopFileDownloadTaskFailed(url, failReason);
        }
        return false;
    }

    public void pause(String url) {
        this.pauseInternal(url, null);
    }

    public void pause(List<String> urls) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.pause(url);
        }
    }

    public void pauseAll() {
        Set<String> urls = this.mFileDownloadTaskMap.keySet();
        this.pause(new ArrayList<String>(urls));
    }

    public void reStart(String url, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
        if (this.isInFileDownloadTaskMap(url)) {
            this.pauseInternal(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    FileDownloadManager.this.start(url, onFileDownloadStatusListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    if (failReason != null) {
                        if (FileDownloadTask.OnStopDownloadFileTaskFailReason.TYPE_TASK_IS_STOPPED.equals(failReason.getType())) {
                            FileDownloadManager.this.start(url, onFileDownloadStatusListener);
                        } else {
                            FileDownloadManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), onFileDownloadStatusListener, false);
                        }
                    } else {
                        FileDownloadManager.this.notifyFileDownloadStatusFailedWithCheck(url, new OnFileDownloadStatusListener.OnFileDownloadStatusFailReason(failReason), onFileDownloadStatusListener, false);
                    }
                }
            });
        } else {
            this.start(url, onFileDownloadStatusListener);
        }
    }

    public void reStart(List<String> urls, OnFileDownloadStatusListener onFileDownloadStatusListener) {
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            this.reStart(url, onFileDownloadStatusListener);
        }
    }

    private void deleteInternal(String url, boolean deleteDownloadedFileInPath, OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        DeleteDownloadFileTask deleteDownloadFileTask = new DeleteDownloadFileTask(url, deleteDownloadedFileInPath, this.mDownloadFileCacher);
        deleteDownloadFileTask.setOnDeleteDownloadFileListener(onDeleteDownloadFileListener);
        this.addAndRunSupportTask(deleteDownloadFileTask);
    }

    public void delete(String url, final boolean deleteDownloadedFileInPath, final OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        this.checkInit();
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("delete \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onDeleteDownloadFileListener != null) {
                onDeleteDownloadFileListener.onDeleteDownloadFileFailed(downloadFileInfo, new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason("the download file doest not exist!", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST));
            }
            return;
        }
        FileDownloadTask task = this.getFileDownloadTask(url);
        if (task == null || task.isStopped()) {
            Log.d((String)TAG, (String)("delete \u76f4\u63a5\u5220\u9664,url:" + url));
            this.deleteInternal(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
        } else {
            Log.d((String)TAG, (String)("delete \u9700\u8981\u5148\u6682\u505c\u540e\u5220\u9664,url:" + url));
            this.pauseInternal(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("delete \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u5220\u9664,url:" + url));
                    FileDownloadManager.this.deleteInternal(url, deleteDownloadedFileInPath, onDeleteDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("delete \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u5220\u9664,url:" + url));
                    if (onDeleteDownloadFileListener != null) {
                        OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileFailed(downloadFileInfo, new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason(failReason), onDeleteDownloadFileListener);
                    }
                }
            });
        }
    }

    public void delete(List<String> urls, boolean deleteDownloadedFile, OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
        this.checkInit();
        if (this.mDeleteDownloadFilesTask != null && !this.mDeleteDownloadFilesTask.isStopped()) {
            return;
        }
        DeleteDownloadFilesTask deleteDownloadFilesTask = new DeleteDownloadFilesTask(urls, deleteDownloadedFile);
        deleteDownloadFilesTask.setOnDeleteDownloadFilesListener(onDeleteDownloadFilesListener);
        new Thread(deleteDownloadFilesTask).start();
        this.mDeleteDownloadFilesTask = deleteDownloadFilesTask;
    }

    private void moveInternal(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        MoveDownloadFileTask moveDownloadFileTask = new MoveDownloadFileTask(url, newDirPath, this.mDownloadFileCacher);
        moveDownloadFileTask.setOnMoveDownloadFileListener(onMoveDownloadFileListener);
        this.addAndRunSupportTask(moveDownloadFileTask);
    }

    public void move(String url, final String newDirPath, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.checkInit();
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("move \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onMoveDownloadFileListener != null) {
                onMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason("the download file doest not exist!", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST));
            }
            return;
        }
        FileDownloadTask task = this.getFileDownloadTask(url);
        if (task == null || task.isStopped()) {
            Log.d((String)TAG, (String)("move \u76f4\u63a5\u79fb\u52a8,url:" + url));
            this.moveInternal(url, newDirPath, onMoveDownloadFileListener);
        } else {
            Log.d((String)TAG, (String)("move \u9700\u8981\u5148\u6682\u505c\u540e\u79fb\u52a8,url:" + url));
            this.pauseInternal(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("move \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u79fb\u52a8,url:" + url));
                    FileDownloadManager.this.moveInternal(url, newDirPath, onMoveDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("move \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u79fb\u52a8,url:" + url));
                    if (onMoveDownloadFileListener != null) {
                        OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(failReason), onMoveDownloadFileListener);
                    }
                }
            });
        }
    }

    public void move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        this.checkInit();
        if (this.mMoveDownloadFilesTask != null && !this.mMoveDownloadFilesTask.isStopped()) {
            return;
        }
        MoveDownloadFilesTask moveDownloadFilesTask = new MoveDownloadFilesTask(urls, newDirPath);
        moveDownloadFilesTask.setOnMoveDownloadFilesListener(onMoveDownloadFilesListener);
        new Thread(moveDownloadFilesTask).start();
        this.mMoveDownloadFilesTask = moveDownloadFilesTask;
    }

    private void renameInternal(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        RenameDownloadFileTask task = new RenameDownloadFileTask(url, newFileName, includedSuffix, this.mDownloadFileCacher);
        task.setOnRenameDownloadFileListener(onRenameDownloadFileListener);
        this.addAndRunSupportTask(task);
    }

    public void rename(String url, final String newFileName, final boolean includedSuffix, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
        this.checkInit();
        final DownloadFileInfo downloadFileInfo = this.getDownloadFile(url);
        if (downloadFileInfo == null) {
            Log.d((String)TAG, (String)("rename \u6587\u4ef6\u4e0d\u5b58\u5728,url:" + url));
            if (onRenameDownloadFileListener != null) {
                onRenameDownloadFileListener.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason("the download file is not exist!", OnRenameDownloadFileListener.OnRenameDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST));
            }
            return;
        }
        FileDownloadTask task = this.getFileDownloadTask(url);
        if (task == null || task.isStopped()) {
            Log.d((String)TAG, (String)("rename \u76f4\u63a5\u91cd\u547d\u540d,url:" + url));
            this.renameInternal(url, newFileName, includedSuffix, onRenameDownloadFileListener);
        } else {
            Log.d((String)TAG, (String)("rename \u9700\u8981\u5148\u6682\u505c\u540e\u91cd\u547d\u540d,url:" + url));
            this.pauseInternal(url, new FileDownloadTask.OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d((String)TAG, (String)("rename \u6682\u505c\u6210\u529f\uff0c\u5f00\u59cb\u91cd\u547d\u540d,url:" + url));
                    FileDownloadManager.this.renameInternal(url, newFileName, includedSuffix, onRenameDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, FileDownloadTask.OnStopDownloadFileTaskFailReason failReason) {
                    Log.d((String)TAG, (String)("rename \u6682\u505c\u5931\u8d25\uff0c\u65e0\u6cd5\u91cd\u547d\u540d,url:" + url));
                    if (onRenameDownloadFileListener != null) {
                        onRenameDownloadFileListener.onRenameDownloadFileFailed(downloadFileInfo, new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason(failReason));
                    }
                }
            });
        }
    }

    private class MoveDownloadFilesTask
    implements Runnable,
    Stoppable {
        private List<String> mUrls;
        private String mNewDirPath;
        private OnMoveDownloadFilesListener mOnMoveDownloadFilesListener;
        private boolean mIsStop = false;
        private boolean mCompleted = false;
        final List<DownloadFileInfo> mDownloadFilesNeedMove = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesMoved = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

        public MoveDownloadFilesTask(List<String> urls, String newDirPath) {
            this.mUrls = urls;
            this.mNewDirPath = newDirPath;
        }

        public void setOnMoveDownloadFilesListener(OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
            this.mOnMoveDownloadFilesListener = onMoveDownloadFilesListener;
        }

        @Override
        public void stop() {
            this.mIsStop = true;
        }

        @Override
        public boolean isStopped() {
            return this.mIsStop;
        }

        @Override
        public void run() {
            DownloadFileInfo downloadFileInfo;
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = FileDownloadManager.this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedMove.add(downloadFileInfo);
            }
            if (this.mOnMoveDownloadFilesListener != null) {
                Log.d((String)TAG, (String)("MoveDownloadFilesTask.run \u51c6\u5907\u6279\u91cf\u79fb\u52a8\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedMove.size()));
                OnMoveDownloadFilesListener.MainThreadHelper.onMoveDownloadFilesPrepared(this.mDownloadFilesNeedMove, this.mOnMoveDownloadFilesListener);
            }
            OnMoveDownloadFileListener onMoveDownloadFileListener = new OnMoveDownloadFileListener(){
                private int deleteCount = 0;

                @Override
                public void onMoveDownloadFilePrepared(DownloadFileInfo downloadFileNeedToMove) {
                    String url = null;
                    if (downloadFileNeedToMove != null) {
                        url = downloadFileNeedToMove.getUrl();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run \u51c6\u5907\u5220\u9664\uff0curl\uff1a" + url));
                    if (MoveDownloadFilesTask.this.mOnMoveDownloadFilesListener != null) {
                        MoveDownloadFilesTask.this.mOnMoveDownloadFilesListener.onMovingDownloadFiles(MoveDownloadFilesTask.this.mDownloadFilesNeedMove, MoveDownloadFilesTask.this.mDownloadFilesMoved, MoveDownloadFilesTask.this.mDownloadFilesSkip, downloadFileNeedToMove);
                    }
                    ++this.deleteCount;
                }

                @Override
                public void onMoveDownloadFileSuccess(DownloadFileInfo downloadFileMoved) {
                    String url = null;
                    if (downloadFileMoved != null) {
                        url = downloadFileMoved.getUrl();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run onMoveDownloadFileSuccess,\u79fb\u52a8\u6210\u529f\uff0cmoveCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedMove.size():" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0curl\uff1a" + url));
                    MoveDownloadFilesTask.this.mDownloadFilesMoved.add(downloadFileMoved);
                    if (this.deleteCount == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() - MoveDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"MoveDownloadFilesTask.run onMoveDownloadFileSuccess,\u79fb\u52a8\u6210\u529f\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                        MoveDownloadFilesTask.this.onMoveDownloadFilesCompleted();
                    }
                }

                @Override
                public void onMoveDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.OnMoveDownloadFileFailReason failReason) {
                    String url = null;
                    if (downloadFileInfo != null) {
                        url = downloadFileInfo.getUrl();
                    }
                    String type = null;
                    if (failReason != null) {
                        type = failReason.getType();
                    }
                    Log.d((String)TAG, (String)("MoveDownloadFilesTask.run onMoveDownloadFileFailed,\u79fb\u52a8\u5931\u8d25\uff0cmoveCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedMove.size():" + MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() + "\uff0curl\uff1a" + url + ",failReason:" + type));
                    MoveDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
                    if (this.deleteCount == MoveDownloadFilesTask.this.mDownloadFilesNeedMove.size() - MoveDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"MoveDownloadFilesTask.run onMoveDownloadFileFailed,\u79fb\u52a8\u5931\u8d25\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                        MoveDownloadFilesTask.this.onMoveDownloadFilesCompleted();
                    }
                }
            };
            for (int i = 0; i < this.mDownloadFilesNeedMove.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedMove.get(i);
                if (downloadFileInfo == null) continue;
                String url = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d((String)TAG, (String)"MoveDownloadFilesTask.run task has been sopped,\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u79fb\u52a8\uff0c\u56de\u8c03onMoveDownloadFilesCompleted");
                    this.onMoveDownloadFilesCompleted();
                }
                FileDownloadManager.this.move(url, this.mNewDirPath, onMoveDownloadFileListener);
            }
        }

        private void onMoveDownloadFilesCompleted() {
            if (this.mCompleted) {
                return;
            }
            if (this.mOnMoveDownloadFilesListener != null) {
                this.mOnMoveDownloadFilesListener.onMoveDownloadFilesCompleted(this.mDownloadFilesNeedMove, this.mDownloadFilesMoved);
            }
            this.mCompleted = true;
            this.mIsStop = true;
        }
    }

    private class DeleteDownloadFilesTask
    implements Runnable,
    Stoppable {
        private List<String> mUrls;
        private boolean mDeleteDownloadedFile;
        private OnDeleteDownloadFilesListener mOnDeleteDownloadFilesListener;
        private boolean mIsStop = false;
        private boolean mCompleted = false;
        private final List<DownloadFileInfo> mDownloadFilesNeedDelete = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesDeleted = new ArrayList<DownloadFileInfo>();
        final List<DownloadFileInfo> mDownloadFilesSkip = new ArrayList<DownloadFileInfo>();

        public DeleteDownloadFilesTask(List<String> urls, boolean deleteDownloadedFile) {
            this.mUrls = urls;
            this.mDeleteDownloadedFile = deleteDownloadedFile;
        }

        public void setOnDeleteDownloadFilesListener(OnDeleteDownloadFilesListener onDeleteDownloadFilesListener) {
            this.mOnDeleteDownloadFilesListener = onDeleteDownloadFilesListener;
        }

        @Override
        public void stop() {
            this.mIsStop = true;
        }

        @Override
        public boolean isStopped() {
            return this.mIsStop;
        }

        @Override
        public void run() {
            DownloadFileInfo downloadFileInfo;
            for (String url : this.mUrls) {
                if (!UrlUtil.isUrl(url) || (downloadFileInfo = FileDownloadManager.this.getDownloadFile(url)) == null) continue;
                this.mDownloadFilesNeedDelete.add(downloadFileInfo);
            }
            if (this.mOnDeleteDownloadFilesListener != null) {
                Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run \u51c6\u5907\u6279\u91cf\u5220\u9664\uff0c\u5927\u5c0f\uff1a" + this.mDownloadFilesNeedDelete.size()));
                OnDeleteDownloadFilesListener.MainThreadHelper.onDeleteDownloadFilePrepared(this.mDownloadFilesNeedDelete, this.mOnDeleteDownloadFilesListener);
            }
            OnDeleteDownloadFileListener onDeleteDownloadFileListener = new OnDeleteDownloadFileListener(){
                private int deleteCount = 0;

                @Override
                public void onDeleteDownloadFilePrepared(DownloadFileInfo downloadFileNeedDelete) {
                    String url = null;
                    if (downloadFileNeedDelete != null) {
                        url = downloadFileNeedDelete.getUrl();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run \u51c6\u5907\u5220\u9664\uff0curl\uff1a" + url));
                    if (DeleteDownloadFilesTask.this.mOnDeleteDownloadFilesListener != null) {
                        DeleteDownloadFilesTask.this.mOnDeleteDownloadFilesListener.onDeletingDownloadFiles(DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete, DeleteDownloadFilesTask.this.mDownloadFilesDeleted, DeleteDownloadFilesTask.this.mDownloadFilesSkip, downloadFileNeedDelete);
                    }
                    ++this.deleteCount;
                }

                @Override
                public void onDeleteDownloadFileSuccess(DownloadFileInfo downloadFileDeleted) {
                    String url = null;
                    if (downloadFileDeleted != null) {
                        url = downloadFileDeleted.getUrl();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run onDeleteDownloadFileSuccess,\u5220\u9664\u6210\u529f\uff0cdeleteCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedDelete.size():" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0curl\uff1a" + url));
                    DeleteDownloadFilesTask.this.mDownloadFilesDeleted.add(downloadFileDeleted);
                    if (this.deleteCount == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() - DeleteDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run onDeleteDownloadFileSuccess,\u5220\u9664\u6210\u529f\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                        DeleteDownloadFilesTask.this.onDeleteDownloadFilesCompleted();
                    }
                }

                @Override
                public void onDeleteDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason failReason) {
                    String url = null;
                    if (downloadFileInfo != null) {
                        url = downloadFileInfo.getUrl();
                    }
                    String type = null;
                    if (failReason != null) {
                        type = failReason.getType();
                    }
                    Log.d((String)TAG, (String)("DeleteDownloadFilesTask.run onDeleteDownloadFileFailed,\u5220\u9664\u5931\u8d25\uff0cdeleteCount\uff1a" + this.deleteCount + ",mDownloadFilesNeedDelete.size():" + DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() + "\uff0curl\uff1a" + url + ",failReason:" + type));
                    DeleteDownloadFilesTask.this.mDownloadFilesSkip.add(downloadFileInfo);
                    if (this.deleteCount == DeleteDownloadFilesTask.this.mDownloadFilesNeedDelete.size() - DeleteDownloadFilesTask.this.mDownloadFilesSkip.size()) {
                        Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run onDeleteDownloadFileFailed,\u5220\u9664\u5931\u8d25\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                        DeleteDownloadFilesTask.this.onDeleteDownloadFilesCompleted();
                    }
                }
            };
            for (int i = 0; i < this.mDownloadFilesNeedDelete.size(); ++i) {
                downloadFileInfo = this.mDownloadFilesNeedDelete.get(i);
                if (downloadFileInfo == null) continue;
                String url = downloadFileInfo.getUrl();
                if (this.isStopped()) {
                    Log.d((String)TAG, (String)"DeleteDownloadFilesTask.run task has been sopped,\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5220\u9664\uff0c\u56de\u8c03onDeleteDownloadFilesCompleted");
                    this.onDeleteDownloadFilesCompleted();
                }
                FileDownloadManager.this.delete(url, this.mDeleteDownloadedFile, onDeleteDownloadFileListener);
            }
        }

        private void onDeleteDownloadFilesCompleted() {
            if (this.mCompleted) {
                return;
            }
            if (this.mOnDeleteDownloadFilesListener != null) {
                this.mOnDeleteDownloadFilesListener.onDeleteDownloadFilesCompleted(this.mDownloadFilesNeedDelete, this.mDownloadFilesDeleted);
            }
            this.mCompleted = true;
            this.mIsStop = true;
        }
    }
}

