/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.xsdgen;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.wiztools.commons.Charsets;
import org.wiztools.xsdgen.ParseException;
import org.wiztools.xsdgen.XsdConfig;
import org.wiztools.xsdgen.XsdGen;

public class XsdGenMain {
    public static void main(String[] arg) throws ParseException, IOException {
        OutputStream os;
        ArgParse cliParser = new ArgParse();
        List extras = Args.parse((Object)cliParser, (String[])arg);
        if (extras.size() != 1 || cliParser.isHelp) {
            Args.usage((Object)cliParser);
            System.exit(1);
        }
        File xmlFile = new File((String)extras.get(0));
        XsdConfig config = new XsdConfig();
        if (cliParser.xsdPrefix != null) {
            config.setXsdPrefix(cliParser.xsdPrefix);
        }
        XsdGen xsdGen = new XsdGen(config);
        Charset charset = cliParser.encoding != null ? Charset.forName(cliParser.encoding) : Charsets.UTF_8;
        if (cliParser.xsdFile != null) {
            File outFile = new File(cliParser.xsdFile);
            if (outFile.exists() && !cliParser.isForceWrite) {
                System.err.println("The outfile already exists!");
                System.exit(2);
            }
            os = new FileOutputStream(outFile);
        } else {
            os = System.out;
        }
        xsdGen.parse(xmlFile).write(os, charset);
    }

    private static class ArgParse {
        @Argument(value="p", alias="prefix", description="The namespace prefix for the xsd (default is `xsd').")
        private String xsdPrefix;
        @Argument(value="o", alias="output", description="Write xsd to outfile instead of STDOUT.")
        private String xsdFile;
        @Argument(value="f", alias="force", description="Force write output XSD even if it exists.")
        private boolean isForceWrite;
        @Argument(value="e", alias="encoding", description="Output encoding (default is `UTF-8').")
        private String encoding;
        @Argument(value="h", alias="help", description="Print usage help.")
        private boolean isHelp;

        private ArgParse() {
        }
    }
}

