/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.xsdgen;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.StringUtil;
import org.wiztools.xsdgen.ParseException;
import org.wiztools.xsdgen.TypeInferenceUtil;
import org.wiztools.xsdgen.XsdConfig;

public final class XsdGen {
    private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private final String xsdPrefix;
    private final boolean enableMaxOccursOnce;
    private Document doc = null;

    public XsdGen() {
        this(new XsdConfig());
    }

    public XsdGen(XsdConfig config) {
        this.xsdPrefix = config.getXsdPrefix();
        this.enableMaxOccursOnce = config.isEnableMaxOccursOnce();
    }

    private void processAttributes(Element inElement, Element outElement) {
        for (int i = 0; i < inElement.getAttributeCount(); ++i) {
            Attribute attr = inElement.getAttribute(i);
            String name = attr.getLocalName();
            String value = attr.getValue();
            Element attrElement = new Element(this.xsdPrefix + ":attribute", XSD_NS_URI);
            attrElement.addAttribute(new Attribute("name", name));
            attrElement.addAttribute(new Attribute("type", this.xsdPrefix + TypeInferenceUtil.getTypeOfContent(value)));
            attrElement.addAttribute(new Attribute("use", "required"));
            outElement.appendChild((Node)attrElement);
        }
    }

    private void recurseGen(Element parent, Element parentOutElement) {
        Element complexType = new Element(this.xsdPrefix + ":complexType", XSD_NS_URI);
        complexType.addAttribute(new Attribute("mixed", "true"));
        Element sequence = new Element(this.xsdPrefix + ":sequence", XSD_NS_URI);
        complexType.appendChild((Node)sequence);
        this.processAttributes(parent, complexType);
        parentOutElement.appendChild((Node)complexType);
        Elements children = parent.getChildElements();
        HashSet<String> elementNamesProcessed = new HashSet<String>();
        for (int i = 0; i < children.size(); ++i) {
            Element e = children.get(i);
            String localName = e.getLocalName();
            String nsURI = e.getNamespaceURI();
            String nsName = e.getQualifiedName();
            if (!elementNamesProcessed.contains(nsName)) {
                if (e.getChildElements().size() > 0) {
                    Element element = new Element(this.xsdPrefix + ":element", XSD_NS_URI);
                    element.addAttribute(new Attribute("name", localName));
                    this.processOccurences(element, parent, localName, nsURI);
                    this.recurseGen(e, element);
                    sequence.appendChild((Node)element);
                } else {
                    String cnt = e.getValue();
                    String eValue = cnt == null ? null : cnt.trim();
                    String type = this.xsdPrefix + TypeInferenceUtil.getTypeOfContent(eValue);
                    Element element = new Element(this.xsdPrefix + ":element", XSD_NS_URI);
                    element.addAttribute(new Attribute("name", localName));
                    this.processOccurences(element, parent, localName, nsURI);
                    int attrCount = e.getAttributeCount();
                    if (attrCount > 0) {
                        Element complexTypeCurrent = new Element(this.xsdPrefix + ":complexType", XSD_NS_URI);
                        complexType.addAttribute(new Attribute("mixed", "true"));
                        Element simpleContent = new Element(this.xsdPrefix + ":simpleContent", XSD_NS_URI);
                        Element extension = new Element(this.xsdPrefix + ":extension", XSD_NS_URI);
                        extension.addAttribute(new Attribute("base", type));
                        this.processAttributes(e, extension);
                        simpleContent.appendChild((Node)extension);
                        complexTypeCurrent.appendChild((Node)simpleContent);
                        element.appendChild((Node)complexTypeCurrent);
                    } else {
                        element.addAttribute(new Attribute("type", type));
                    }
                    sequence.appendChild((Node)element);
                }
            }
            elementNamesProcessed.add(nsName);
        }
    }

    private void processOccurences(Element element, Element parent, String localName, String nsURI) {
        if (parent.getChildElements(localName, nsURI).size() > 1) {
            element.addAttribute(new Attribute("maxOccurs", "unbounded"));
        } else {
            element.addAttribute(new Attribute("minOccurs", "0"));
            if (this.enableMaxOccursOnce) {
                element.addAttribute(new Attribute("maxOccurs", "1"));
            }
        }
    }

    private Document getDocument(File file) throws ParsingException, IOException {
        boolean hasXmlns;
        Builder parser = new Builder();
        Document d = parser.build(file);
        Element rootElement = d.getRootElement();
        Element outRoot = new Element(this.xsdPrefix + ":schema", XSD_NS_URI);
        Document outDoc = new Document(outRoot);
        String nsPrefix = rootElement.getNamespacePrefix();
        boolean bl = hasXmlns = rootElement.getNamespaceDeclarationCount() > 0;
        if (hasXmlns || StringUtil.isNotEmpty((String)nsPrefix)) {
            outRoot.addAttribute(new Attribute("targetNamespace", rootElement.getNamespaceURI()));
            outRoot.addAttribute(new Attribute("elementFormDefault", "qualified"));
        }
        for (int i = 0; i < rootElement.getNamespaceDeclarationCount(); ++i) {
            String nsPrefix2 = rootElement.getNamespacePrefix(i);
            String nsURI = rootElement.getNamespaceURI(nsPrefix2);
            outRoot.addNamespaceDeclaration(nsPrefix, nsURI);
        }
        Element rootElementXsd = new Element(this.xsdPrefix + ":element", XSD_NS_URI);
        rootElementXsd.addAttribute(new Attribute("name", rootElement.getLocalName()));
        outRoot.appendChild((Node)rootElementXsd);
        this.recurseGen(rootElement, rootElementXsd);
        return outDoc;
    }

    public XsdGen parse(File file) throws IOException, ParseException {
        try {
            this.doc = this.getDocument(file);
            return this;
        }
        catch (ParsingException ex) {
            throw new ParseException(ex);
        }
    }

    public void write(OutputStream os) throws IOException {
        if (this.doc == null) {
            throw new IllegalStateException("Call parse() before calling this method!");
        }
        this.write(os, Charsets.UTF_8);
    }

    public void write(OutputStream os, Charset charset) throws IOException {
        if (this.doc == null) {
            throw new IllegalStateException("Call parse() before calling this method!");
        }
        Serializer serializer = new Serializer(os, charset.name());
        serializer.setIndent(4);
        serializer.write(this.doc);
    }

    public String toString() {
        return this.doc.toXML();
    }
}

