/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Password;
import org.wiremock.url.PasswordValue;
import org.wiremock.url.UserInfo;
import org.wiremock.url.Username;
import org.wiremock.url.UsernameValue;

final class UserInfoValue
implements UserInfo {
    private final String userInfo;
    private final Username username;
    private final @Nullable Password password;

    UserInfoValue(String userInfo) {
        this.userInfo = userInfo;
        String[] components = userInfo.split(":", 2);
        this.username = new UsernameValue(components[0]);
        this.password = components.length == 2 ? new PasswordValue(components[1]) : null;
    }

    UserInfoValue(Username username, @Nullable Password password) {
        this.userInfo = password == null ? username.toString() : String.valueOf(username) + ":" + String.valueOf(password);
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return this.userInfo;
    }

    @Override
    public Username getUsername() {
        return this.username;
    }

    @Override
    public @Nullable Password getPassword() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UserInfo) {
            UserInfo that = (UserInfo)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.userInfo);
    }

    @Override
    public UserInfo normalise() {
        Password normalisedPassword;
        Username normalisedUsername = (Username)this.username.normalise();
        Password password = normalisedPassword = this.password != null ? (Password)this.password.normalise() : null;
        if (normalisedUsername.equals(this.username) && Objects.equals(normalisedPassword, this.password)) {
            return this;
        }
        return new UserInfoValue(normalisedUsername, normalisedPassword);
    }

    @Override
    public boolean isNormalForm() {
        return this.username.isNormalForm() && (this.password == null || this.password.isNormalForm());
    }
}

