/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalUserInfo;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.UserInfo;
import org.wiremock.url.UserInfoValue;

public final class UserInfoParser
implements PercentEncodedStringParser<UserInfo> {
    public static final UserInfoParser INSTANCE = new UserInfoParser();
    static final String userInfoRegex = "(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*";
    private final Pattern userInfoPattern = Pattern.compile("^(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*$");
    static final boolean[] usernameCharSet = Constants.combine(Constants.unreservedCharSet, new boolean[][]{Constants.subDelimCharSet});
    static final boolean[] userInfoCharSet = Constants.combine(usernameCharSet, new boolean[][]{Constants.include(':')});

    public Class<UserInfo> getType() {
        return UserInfo.class;
    }

    public UserInfo parse(String stringForm) {
        if (this.userInfoPattern.matcher(stringForm).matches()) {
            return new UserInfoValue(stringForm);
        }
        throw new IllegalUserInfo(stringForm);
    }

    @Override
    public UserInfo encode(String unencoded) {
        String encoded = PercentEncoding.encode(unencoded, userInfoCharSet);
        return this.parse(encoded);
    }
}

