/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.stringparser.StringParser;
import org.wiremock.url.IllegalAbsoluteUrl;
import org.wiremock.url.IllegalRelativeUrl;
import org.wiremock.url.Uri;
import org.wiremock.url.UriParser;
import org.wiremock.url.UrlWithAuthority;

public class UrlWithAuthorityParser
implements StringParser<UrlWithAuthority> {
    public static final UrlWithAuthorityParser INSTANCE = new UrlWithAuthorityParser(UriParser.INSTANCE);
    private final UriParser uriParser;

    public UrlWithAuthorityParser(UriParser uriParser) {
        this.uriParser = uriParser;
    }

    public Class<UrlWithAuthority> getType() {
        return UrlWithAuthority.class;
    }

    public UrlWithAuthority parse(String url) {
        Uri uri = this.uriParser.parse(url);
        if (uri instanceof UrlWithAuthority) {
            UrlWithAuthority absoluteUri = (UrlWithAuthority)uri;
            return absoluteUri;
        }
        if (url.contains(":")) {
            throw new IllegalAbsoluteUrl(url);
        }
        throw new IllegalRelativeUrl(url);
    }
}

