/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.StringParser;
import org.wiremock.url.Authority;
import org.wiremock.url.AuthorityParser;
import org.wiremock.url.Fragment;
import org.wiremock.url.IllegalAbsoluteUrl;
import org.wiremock.url.IllegalRelativeUrl;
import org.wiremock.url.IllegalUri;
import org.wiremock.url.IllegalUriPart;
import org.wiremock.url.Path;
import org.wiremock.url.PathParser;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;
import org.wiremock.url.SchemeRegistry;
import org.wiremock.url.Uri;
import org.wiremock.url.UriBuilder;

public final class UriParser
implements StringParser<Uri> {
    public static final UriParser INSTANCE = new UriParser();
    private static final Pattern regex = Pattern.compile("^(?:(?<scheme>[^:/?#]+):)?(?://(?<authority>[^/?#]*))?(?<path>[^?#]*)(?:\\?(?<query>[^#]*))?(?:#(?<fragment>.*))?");
    private final SchemeRegistry schemeRegistry;

    public UriParser() {
        this(SchemeRegistry.INSTANCE);
    }

    public UriParser(SchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public Class<Uri> getType() {
        return Uri.class;
    }

    public Uri parse(String stringForm) {
        try {
            Matcher result = regex.matcher(stringForm);
            if (!result.matches()) {
                if (stringForm.contains(":")) {
                    throw new IllegalAbsoluteUrl(stringForm);
                }
                throw new IllegalRelativeUrl(stringForm);
            }
            String schemeString = result.group("scheme");
            Scheme scheme = schemeString == null ? null : (Scheme)this.schemeRegistry.parse(schemeString);
            String queryString = result.group("query");
            Query query = queryString == null ? null : Query.parse(queryString);
            String fragmentString = result.group("fragment");
            Fragment fragment = fragmentString == null ? null : Fragment.parse(fragmentString);
            Authority authority = this.extractAuthorityOrNull(result);
            Path path = PathParser.INSTANCE.parse(result.group("path"));
            UriBuilder uriBuilder = new UriBuilder();
            ((Uri.Builder)((Uri.Builder)uriBuilder.setScheme(scheme).setAuthority(authority).setPath(path)).setQuery(query)).setFragment(fragment);
            return uriBuilder.build(stringForm);
        }
        catch (IllegalUriPart illegalPart) {
            throw new IllegalUri(stringForm, illegalPart);
        }
    }

    private @Nullable Authority extractAuthorityOrNull(Matcher matcher) {
        String authorityStr = matcher.group("authority");
        if (authorityStr == null) {
            return null;
        }
        return AuthorityParser.INSTANCE.parse(authorityStr);
    }
}

