/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalSegment;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.Segment;
import org.wiremock.url.SegmentValue;

public final class SegmentParser
implements PercentEncodedStringParser<Segment> {
    public static final SegmentParser INSTANCE = new SegmentParser();
    private static final String segmentRegex = "[^#?/\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*";
    private static final Pattern segmentPattern = Pattern.compile("^[^#?/\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*$");
    static final boolean[] segmentCharSet = Constants.combine(Constants.unreservedCharSet, Constants.subDelimCharSet, Constants.include(':', '@'));

    public Class<Segment> getType() {
        return Segment.class;
    }

    public Segment parse(String stringForm) {
        return this.build(stringForm, () -> this.buildSafely(stringForm));
    }

    private Segment buildSafely(String stringForm) {
        if (segmentPattern.matcher(stringForm).matches()) {
            return new SegmentValue(stringForm);
        }
        throw new IllegalSegment(stringForm);
    }

    @Override
    public Segment encode(String unencoded) {
        return this.build(unencoded, () -> new SegmentValue(PercentEncoding.encode(unencoded, segmentCharSet), true));
    }

    Segment build(String stringForm, Supplier<Segment> builder) {
        return switch (stringForm) {
            case "" -> Segment.EMPTY;
            case "." -> Segment.DOT;
            case ".." -> Segment.DOT_DOT;
            default -> builder.get();
        };
    }
}

