/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.url.AbsoluteUri;
import org.wiremock.url.AbsoluteUrl;
import org.wiremock.url.IllegalScheme;
import org.wiremock.url.OpaqueUri;
import org.wiremock.url.Path;
import org.wiremock.url.Port;
import org.wiremock.url.SchemeRegistry;
import org.wiremock.url.Uri;
import org.wiremock.url.UrlWithAuthority;

public interface Scheme
extends ParsedString {
    public Scheme normalise();

    public @Nullable Port getDefaultPort();

    default public boolean isNormalForm() {
        return this.normalise().equals(this);
    }

    default public AbsoluteUri resolve(Uri other) {
        return this.asUri().resolve(other);
    }

    default public AbsoluteUrl resolve(UrlWithAuthority other) {
        return this.asUri().resolve(other);
    }

    private OpaqueUri asUri() {
        return OpaqueUri.of(this, Path.EMPTY);
    }

    public static Scheme parse(String scheme) throws IllegalScheme {
        return (Scheme)SchemeRegistry.INSTANCE.parse(scheme);
    }

    public static Scheme register(String schemeString) throws IllegalScheme {
        return Scheme.register(schemeString, null);
    }

    public static Scheme register(String schemeString, @Nullable Port defaultPort) throws IllegalScheme {
        return SchemeRegistry.INSTANCE.register(schemeString, defaultPort);
    }
}

