/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbstractUriValue;
import org.wiremock.url.Fragment;
import org.wiremock.url.IllegalPath;
import org.wiremock.url.IllegalPathAndQuery;
import org.wiremock.url.IllegalRelativeUrl;
import org.wiremock.url.Path;
import org.wiremock.url.Query;
import org.wiremock.url.RelativeUrl;

final class RelativeUrlValue
extends AbstractUriValue
implements RelativeUrl {
    RelativeUrlValue(@Nullable String stringValue, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        super(stringValue, null, null, path, query, fragment);
        if (!path.isEmpty()) {
            if (path.getFirstSegment().toString().contains(":")) {
                throw new IllegalRelativeUrl(this.toString(), "Illegal relative url: `" + String.valueOf(this) + "` - a relative url without authority's path may not contain a colon (`:`) in the first segment, as that implies a scheme", new IllegalPath(path.toString(), "Illegal path: `" + String.valueOf(path) + "` - may not contain a colon (`:`) in the first segment of a relative url with no authority"));
            }
            if (path.toString().startsWith("//")) {
                throw new IllegalPathAndQuery(this.toString(), "Illegal relative url: `" + String.valueOf(this) + "` - a relative url without authority's path may not start with //, as that would make the first segment an authority", new IllegalPath(path.toString(), "Illegal path: `" + String.valueOf(path) + "` - may not start with // in a relative url with no authority"));
            }
        }
    }
}

