/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalSegment;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.QueryParamValue;
import org.wiremock.url.QueryParamValueValue;
import org.wiremock.url.QueryParser;

public final class QueryParamValueParser
implements PercentEncodedStringParser<QueryParamValue> {
    public static final QueryParamValueParser INSTANCE = new QueryParamValueParser();
    private static final String queryParamValueRegex = "[^#&\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*";
    private static final Pattern queryParamValuePattern = Pattern.compile("^[^#&\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*$");
    static final boolean[] queryParamValueCharSet = Constants.remove(QueryParser.queryCharSet, '&', '+');

    public Class<QueryParamValue> getType() {
        return QueryParamValue.class;
    }

    public QueryParamValue parse(String stringForm) {
        if (queryParamValuePattern.matcher(stringForm).matches()) {
            return new QueryParamValueValue(stringForm);
        }
        throw new IllegalSegment(stringForm);
    }

    @Override
    public QueryParamValue encode(String unencoded) {
        return new QueryParamValueValue(PercentEncoding.encode(unencoded, queryParamValueCharSet), true);
    }
}

