/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamValue;

public interface QueryParamReader {
    public List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> getEntries();

    default public List<@Nullable QueryParamValue> get(String key) {
        return this.get(QueryParamKey.encode(key));
    }

    default public List<@Nullable QueryParamValue> get(QueryParamKey key) {
        List<@Nullable QueryParamValue> result = this.asMap().get(key.normalise());
        return Objects.requireNonNullElse(result, List.of());
    }

    default public boolean contains(String key) {
        return this.contains(QueryParamKey.encode(key));
    }

    default public boolean contains(QueryParamKey key) {
        return this.asMap().containsKey(key.normalise());
    }

    default public Set<QueryParamKey> getKeys() {
        return this.asMap().keySet();
    }

    default public Map<QueryParamKey, List<@Nullable QueryParamValue>> asMap() {
        return this.getEntries().stream().collect(Collectors.groupingBy(entry -> (QueryParamKey)((QueryParamKey)entry.getKey()).normalise(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    default public @Nullable QueryParamValue getFirst(String key) {
        return this.getFirst(QueryParamKey.encode(key));
    }

    default public @Nullable QueryParamValue getFirst(QueryParamKey key) {
        List<@Nullable QueryParamValue> values = this.get(key);
        return values.isEmpty() ? null : Objects.requireNonNullElse(values.get(0), QueryParamValue.EMPTY);
    }

    default public Map<String, List<String>> asDecodedMap() {
        return this.asMap().entrySet().stream().collect(Collectors.toMap(entry -> ((QueryParamKey)entry.getKey()).decode(), entry -> ((List)entry.getValue()).stream().map(value -> value != null ? value.decode() : "").collect(Collectors.toList())));
    }

    default public List<String> getDecoded(String key) {
        List<String> result = this.asDecodedMap().get(key);
        return result != null ? result : List.of();
    }

    default public @Nullable String getFirstDecoded(String key) {
        List<String> result = this.getDecoded(key);
        return result.isEmpty() ? null : result.get(0);
    }
}

