/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.PercentEncoding;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamKeyParser;

final class QueryParamKeyValue
implements QueryParamKey {
    private final String stringForm;
    private final MemoisedNormalisable<QueryParamKey> memoisedNormalisable;

    public QueryParamKeyValue(String stringForm) {
        this(stringForm, null);
    }

    QueryParamKeyValue(String stringForm, @Nullable Boolean isNormalForm) {
        this.stringForm = stringForm;
        this.memoisedNormalisable = new MemoisedNormalisable<QueryParamKey>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.stringForm;
    }

    @Override
    public String decode() {
        return PercentEncoding.decode(this.stringForm.replace('+', ' '));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParamKey) {
            QueryParamKey that = (QueryParamKey)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.stringForm.hashCode();
    }

    @Override
    public QueryParamKey normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable QueryParamKey normaliseWork() {
        String result = PercentEncoding.normalise(this.stringForm.replace('+', ' '), QueryParamKeyParser.queryParamKeyCharSet);
        return result != null ? new QueryParamKeyValue(result, true) : null;
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return PercentEncoding.isNormalForm(this.stringForm, QueryParamKeyParser.queryParamKeyCharSet);
    }
}

