/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Lists;
import org.wiremock.url.Query;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamValue;
import org.wiremock.url.QueryValue;

final class QueryBuilder
implements Query.Builder {
    private final List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> mutableParams;

    QueryBuilder() {
        this.mutableParams = new ArrayList<Map.Entry<QueryParamKey, QueryParamValue>>();
    }

    QueryBuilder(List<Map.Entry<QueryParamKey, @Nullable QueryParamValue>> query) {
        this.mutableParams = new ArrayList<Map.Entry<QueryParamKey, QueryParamValue>>(query);
    }

    @Override
    public Query.Builder append(String key, @Nullable String value, String ... otherValues) {
        this.append(key, value);
        for (String otherValue : otherValues) {
            this.append(key, otherValue);
        }
        return this;
    }

    @Override
    public Query.Builder append(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        this.append(key, value);
        for (QueryParamValue otherValue : otherValues) {
            this.append(key, otherValue);
        }
        return this;
    }

    @Override
    public Query.Builder append(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        for (QueryParamValue queryParamValue : values) {
            this.append(key, queryParamValue);
        }
        return this;
    }

    private void append(String key, @Nullable String value) {
        this.append(QueryParamKey.encode(key), value);
    }

    private void append(QueryParamKey key, @Nullable String value) {
        this.append(key, value != null ? QueryParamValue.encode(value) : null);
    }

    private void append(QueryParamKey key, @Nullable QueryParamValue value) {
        this.mutableParams.add(new AbstractMap.SimpleEntry<QueryParamKey, QueryParamValue>(key, value));
    }

    @Override
    public Query.Builder put(String key, @Nullable String value, String ... otherValues) {
        QueryParamKey encodedKey = QueryParamKey.encode(key);
        this.remove(encodedKey);
        this.append(encodedKey, value);
        for (String otherValue : otherValues) {
            this.append(encodedKey, otherValue);
        }
        return this;
    }

    @Override
    public Query.Builder put(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        this.remove(key);
        this.append(key, value, otherValues);
        return this;
    }

    @Override
    public Query.Builder put(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        this.remove(key);
        this.append(key, values);
        return this;
    }

    @Override
    public Query.Builder remove(String key) {
        return this.remove(QueryParamKey.encode(key));
    }

    @Override
    public Query.Builder remove(QueryParamKey key) {
        this.mutableParams.removeIf(e -> ((QueryParamKey)e.getKey()).equals(key));
        return this;
    }

    @Override
    public Query.Builder remove(String key, @Nullable String value, String ... otherValues) {
        return this.remove(QueryParamKey.encode(key), QueryValue.encodeValues(value, otherValues));
    }

    @Override
    public Query.Builder remove(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        return this.remove(key, Lists.of(value, otherValues));
    }

    @Override
    public Query.Builder remove(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        this.mutableParams.removeIf(e -> ((QueryParamKey)e.getKey()).equals(key) && values.contains(e.getValue()));
        return this;
    }

    @Override
    public Query build() {
        if (this.mutableParams.isEmpty()) {
            return Query.EMPTY;
        }
        return new QueryValue(this.mutableParams);
    }
}

