/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.wiremock.stringparser.ParsedString;
import org.wiremock.url.IllegalQuery;
import org.wiremock.url.Lists;
import org.wiremock.url.PercentEncoded;
import org.wiremock.url.QueryBuilder;
import org.wiremock.url.QueryParamKey;
import org.wiremock.url.QueryParamReader;
import org.wiremock.url.QueryParamValue;
import org.wiremock.url.QueryParser;
import org.wiremock.url.QueryValue;

public interface Query
extends PercentEncoded<Query>,
QueryParamReader,
ParsedString {
    public static final Query EMPTY = new QueryValue("", List.of(), true);

    public static Query parse(String query) throws IllegalQuery {
        return QueryParser.INSTANCE.parse(query);
    }

    public static Query encode(String unencoded) {
        return QueryParser.INSTANCE.encode(unencoded);
    }

    @Override
    public Query normalise();

    default public Query with(String key, @Nullable String value, String ... otherValues) {
        return this.with(QueryParamKey.encode(key), QueryValue.encodeValues(value, otherValues));
    }

    default public Query with(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        return this.with(key, Lists.of(value, otherValues));
    }

    default public Query with(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        return this.transform(q -> q.append(key, values));
    }

    default public Query replace(String key, @Nullable String value, String ... otherValues) {
        return this.replace(QueryParamKey.encode(key), QueryValue.encodeValues(value, otherValues));
    }

    default public Query replace(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        return this.replace(key, Lists.of(value, otherValues));
    }

    default public Query replace(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        return this.transform(q -> q.put(key, values));
    }

    default public Query without(String key) {
        return this.without(QueryParamKey.encode(key));
    }

    default public Query without(QueryParamKey key) {
        return this.transform(q -> q.remove(key));
    }

    default public Query without(String key, @Nullable String value, String ... otherValues) {
        return this.without(QueryParamKey.encode(key), QueryValue.encodeValues(value, otherValues));
    }

    default public Query without(QueryParamKey key, @Nullable QueryParamValue value, QueryParamValue ... otherValues) {
        return this.without(key, Lists.of(value, otherValues));
    }

    default public Query without(QueryParamKey key, List<? extends @Nullable QueryParamValue> values) {
        return this.transform(q -> q.remove(key, values));
    }

    public static Builder builder() {
        return new QueryBuilder();
    }

    public Builder thaw();

    default public Query transform(Consumer<Builder> transformer) {
        Builder builder = this.thaw();
        transformer.accept(builder);
        return builder.build();
    }

    public static interface Builder {
        public Builder append(String var1, @Nullable String var2, String ... var3);

        public Builder append(QueryParamKey var1, @Nullable QueryParamValue var2, QueryParamValue ... var3);

        public Builder append(QueryParamKey var1, List<? extends @Nullable QueryParamValue> var2);

        public Builder put(String var1, @Nullable String var2, String ... var3);

        public Builder put(QueryParamKey var1, @Nullable QueryParamValue var2, QueryParamValue ... var3);

        public Builder put(QueryParamKey var1, List<? extends @Nullable QueryParamValue> var2);

        public Builder remove(String var1);

        public Builder remove(QueryParamKey var1);

        public Builder remove(String var1, @Nullable String var2, String ... var3);

        public Builder remove(QueryParamKey var1, @Nullable QueryParamValue var2, QueryParamValue ... var3);

        public Builder remove(QueryParamKey var1, List<? extends @Nullable QueryParamValue> var2);

        public Query build();
    }
}

