/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wiremock.stringparser.StringParser;
import org.wiremock.url.IllegalPort;
import org.wiremock.url.Port;
import org.wiremock.url.PortValue;

public final class PortParser
implements StringParser<Port> {
    public static final PortParser INSTANCE = new PortParser();
    static final int MAX_PORT = Integer.MAX_VALUE;
    private final Map<Integer, PortValue> portsByInt = new ConcurrentHashMap<Integer, PortValue>();

    public Class<Port> getType() {
        return Port.class;
    }

    PortValue of(int port) throws IllegalPort {
        return this.portsByInt.computeIfAbsent(port, p -> {
            PortParser.validate(p);
            return new PortValue((int)p, String.valueOf(p), true);
        });
    }

    public Port parse(String stringForm) {
        try {
            if (stringForm.startsWith("+")) {
                throw new IllegalPort(stringForm);
            }
            int port = Integer.parseInt(stringForm);
            String canonical = String.valueOf(port);
            boolean isNormalForm = stringForm.equals(canonical);
            if (isNormalForm) {
                return this.of(port);
            }
            PortParser.validate(port);
            return new PortValue(port, stringForm, false);
        }
        catch (NumberFormatException e) {
            throw new IllegalPort(stringForm);
        }
    }

    private static void validate(int port) {
        if (port < 0) {
            throw new IllegalPort(port);
        }
    }
}

