/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Lazy;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.Path;
import org.wiremock.url.PathParser;
import org.wiremock.url.Segment;
import org.wiremock.url.SegmentValue;

final class PathValue
implements Path {
    private final String path;
    private final MemoisedNormalisable<Path> memoisedNormalisable;
    @Language(value="RegExp")
    private static final String DOT = "(?:\\.|%2[Ee])";
    private static final Map<String, Pattern> CACHE = new ConcurrentHashMap<String, Pattern>();
    private final Lazy<List<Segment>> segments = Lazy.lazy(this::buildSegments);

    PathValue(String path) {
        this(path, null);
    }

    PathValue(String path, @Nullable Boolean isNormalForm) {
        this.path = path;
        this.memoisedNormalisable = new MemoisedNormalisable<Path>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.path;
    }

    @Override
    public boolean isAbsolute() {
        return !this.path.isEmpty() && this.path.charAt(0) == '/';
    }

    @Override
    public Path normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable Path normaliseWork() {
        if (this.equals(ROOT) || this.equals(EMPTY)) {
            return null;
        }
        StringBuilder inputBuffer = new StringBuilder(this.path);
        StringBuilder outputBuffer = new StringBuilder();
        while (!inputBuffer.isEmpty()) {
            if (PathValue.remove(inputBuffer, "^..?/") || PathValue.replace(inputBuffer, "^/.(/|$)", "/")) continue;
            if (PathValue.replace(inputBuffer, "^/..(/|$)", "/")) {
                int lastSegment = outputBuffer.lastIndexOf("/");
                if (lastSegment < 0) continue;
                outputBuffer.replace(lastSegment, outputBuffer.length(), "");
                continue;
            }
            if (PathValue.remove(inputBuffer, "^..?$")) continue;
            int endOfFirstSegment = PathValue.getEndOfFirstSegment(inputBuffer);
            outputBuffer.append(inputBuffer, 0, endOfFirstSegment);
            inputBuffer.replace(0, endOfFirstSegment, "");
        }
        String outStr = PathParser.INSTANCE.normalisePercentEncoded(outputBuffer.toString());
        if (outStr.equals(this.path)) {
            return null;
        }
        if (outStr.equals(ROOT.toString())) {
            return ROOT;
        }
        return new PathValue(outStr, true);
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return this.normalise().equals(this);
    }

    private static int getEndOfFirstSegment(StringBuilder inputBuffer) {
        int indexOfSlashAtEndOfFirstSegment = inputBuffer.charAt(0) == '/' ? inputBuffer.indexOf("/", 1) : inputBuffer.indexOf("/");
        if (indexOfSlashAtEndOfFirstSegment == -1) {
            return inputBuffer.length();
        }
        return indexOfSlashAtEndOfFirstSegment;
    }

    private static boolean remove(StringBuilder original, @Language(value="RegExp") String pattern) {
        return PathValue.replace(original, pattern, "");
    }

    private static boolean replace(StringBuilder original, @Language(value="RegExp") String pattern, String replacement) {
        Pattern p = CACHE.computeIfAbsent(pattern, regex -> Pattern.compile(regex.replaceAll("\\.", Matcher.quoteReplacement(DOT))));
        Matcher matcher = p.matcher(original);
        boolean matches = matcher.find();
        if (matches) {
            original.replace(matcher.start(), matcher.end(), replacement);
        }
        return matches;
    }

    @Override
    public Path resolve(Path other) {
        int lastIndexOfSlash;
        Path result = other.toString().isEmpty() ? this : (other.isAbsolute() ? other : ((lastIndexOfSlash = this.path.lastIndexOf(47)) == -1 ? other : PathParser.INSTANCE.construct(this.path.substring(0, lastIndexOfSlash + 1) + String.valueOf(other))));
        return result.normalise();
    }

    @Override
    public List<Segment> getSegments() {
        return this.segments.get();
    }

    private List<Segment> buildSegments() {
        return Arrays.stream(this.path.split("/", -1)).map(s -> new SegmentValue((String)s)).toList();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

