/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalPath;
import org.wiremock.url.Path;
import org.wiremock.url.PathValue;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;

public final class PathParser
implements PercentEncodedStringParser<Path> {
    public static final PathParser INSTANCE = new PathParser();
    static final String pathRegex = "[^#?\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*";
    private final Pattern pathPattern = Pattern.compile("^[^#?\\u0000-\\u0008\\u000A-\\u001F\\u007F\\u0080-\\u009F\\uD800-\\uDFFF]*$");
    private static final boolean[] charactersToLeaveAsIs = Constants.include('/');
    static final boolean[] pathCharSet = Constants.combine(Constants.pcharCharSet, new boolean[][]{charactersToLeaveAsIs});

    public Class<Path> getType() {
        return Path.class;
    }

    public Path parse(String stringForm) {
        if (stringForm.isEmpty()) {
            return Path.EMPTY;
        }
        if (stringForm.equals("/")) {
            return Path.ROOT;
        }
        if (this.pathPattern.matcher(stringForm).matches()) {
            return new PathValue(stringForm);
        }
        throw new IllegalPath(stringForm);
    }

    Path construct(String stringForm) {
        if (stringForm.isEmpty()) {
            return Path.EMPTY;
        }
        if (stringForm.equals("/")) {
            return Path.ROOT;
        }
        return new PathValue(stringForm);
    }

    @Override
    public Path encode(String unencoded) {
        if (unencoded.isEmpty()) {
            return Path.EMPTY;
        }
        if (unencoded.equals("/")) {
            return Path.ROOT;
        }
        return new PathValue(PercentEncoding.encode(unencoded, pathCharSet), true);
    }

    String normalisePercentEncoded(String unencoded) {
        String result = PercentEncoding.normalise(unencoded, pathCharSet, charactersToLeaveAsIs);
        return result != null ? result : unencoded;
    }
}

