/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.IllegalPassword;
import org.wiremock.url.Password;
import org.wiremock.url.PasswordValue;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;

public final class PasswordParser
implements PercentEncodedStringParser<Password> {
    public static final PasswordParser INSTANCE = new PasswordParser();
    final String passwordRegex = "(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*";
    private final Pattern passwordPattern = Pattern.compile("^(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]|%[0-9a-fA-F]{2})*$");
    private static final boolean[] passwordCharSet = Constants.combine(Constants.unreservedCharSet, Constants.subDelimCharSet, Constants.include(':'));

    public Class<Password> getType() {
        return Password.class;
    }

    public Password parse(String stringForm) throws IllegalPassword {
        if (this.passwordPattern.matcher(stringForm).matches()) {
            return new PasswordValue(stringForm);
        }
        throw new IllegalPassword(stringForm);
    }

    @Override
    public Password encode(String unencoded) {
        String result = PercentEncoding.encode(unencoded, passwordCharSet);
        return new PasswordValue(result, true);
    }
}

