/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbstractAbsoluteUrlValue;
import org.wiremock.url.BaseUrl;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.IllegalOrigin;
import org.wiremock.url.Origin;
import org.wiremock.url.Path;
import org.wiremock.url.Scheme;
import org.wiremock.url.ServersideAbsoluteUrl;

final class OriginValue
extends AbstractAbsoluteUrlValue<ServersideAbsoluteUrl>
implements Origin {
    private final HostAndPort hostAndPort;

    OriginValue(@Nullable String stringValue, Scheme scheme, HostAndPort authority) {
        super(stringValue, scheme, authority, Path.EMPTY, null, null);
        this.hostAndPort = Objects.requireNonNull(authority);
        if (!authority.isNormalForm(scheme)) {
            throw new IllegalOrigin(this.toString());
        }
    }

    OriginValue(Scheme scheme, HostAndPort authority) {
        this(null, scheme, authority);
    }

    @Override
    public BaseUrl normalise() {
        return (BaseUrl)this.transform(b -> b.setPath(Path.ROOT));
    }

    @Override
    public HostAndPort getAuthority() {
        return this.hostAndPort;
    }
}

