/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.wiremock.stringparser.StringParser;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.IllegalOrigin;
import org.wiremock.url.Origin;
import org.wiremock.url.OriginValue;
import org.wiremock.url.Scheme;
import org.wiremock.url.Uri;
import org.wiremock.url.UriParser;

public final class OriginParser
implements StringParser<Origin> {
    public static final OriginParser INSTANCE = new OriginParser(UriParser.INSTANCE);
    private final UriParser uriParser;

    public OriginParser(UriParser uriParser) {
        this.uriParser = uriParser;
    }

    public Class<Origin> getType() {
        return Origin.class;
    }

    public Origin parse(String url) throws IllegalOrigin {
        Uri uri = this.uriParser.parse(url);
        if (uri instanceof Origin) {
            Origin origin = (Origin)uri;
            return origin;
        }
        throw new IllegalOrigin(url);
    }

    Origin of(Scheme scheme, HostAndPort hostAndPort) {
        if (scheme.isNormalForm() && hostAndPort.isNormalForm(scheme)) {
            return new OriginValue(scheme, hostAndPort);
        }
        throw new IllegalOrigin(String.valueOf(scheme) + "://" + String.valueOf(hostAndPort));
    }
}

