/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.AbstractAbsoluteUriValue;
import org.wiremock.url.Fragment;
import org.wiremock.url.OpaqueUri;
import org.wiremock.url.Path;
import org.wiremock.url.PathValue;
import org.wiremock.url.Query;
import org.wiremock.url.Scheme;

final class OpaqueUriValue
extends AbstractAbsoluteUriValue<OpaqueUri>
implements OpaqueUri {
    OpaqueUriValue(@Nullable String stringValue, Scheme scheme, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        super(stringValue, scheme, null, path, query, fragment);
    }

    OpaqueUriValue(Scheme scheme, Path path, @Nullable Query query, @Nullable Fragment fragment) {
        this(null, scheme, path, query, fragment);
    }

    @Override
    public OpaqueUri normalise() {
        Fragment normalisedFragment;
        Scheme normalisedScheme = this.nonNullScheme.normalise();
        Path normalisedPath = this.path.normalise();
        if (normalisedPath.toString().startsWith("//")) {
            normalisedPath = new PathValue(normalisedPath.toString().replaceFirst("^//+", "/"), true);
        }
        Query normalisedQuery = this.query == null ? null : this.query.normalise();
        Fragment fragment = normalisedFragment = this.fragment == null ? null : this.fragment.normalise();
        if (this.nonNullScheme.equals(normalisedScheme) && this.path.equals(normalisedPath) && Objects.equals(this.query, normalisedQuery) && Objects.equals(this.fragment, normalisedFragment)) {
            return this;
        }
        return new OpaqueUriValue(normalisedScheme, normalisedPath, normalisedQuery, normalisedFragment);
    }
}

