/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public final class Lists {
    static <T> List<@Nullable T> of(@Nullable T value, @Nullable T[] otherValues) {
        ArrayList<T> values = new ArrayList<T>(1 + otherValues.length);
        values.add(value);
        Collections.addAll(values, otherValues);
        return values;
    }

    public static <C extends Collection<T>, T> List<? extends T> concat(Collection<? extends C> lists) {
        return Lists.concat(lists.stream());
    }

    @SafeVarargs
    public static <T> List<? extends T> concat(Collection<? extends T> ... lists) {
        return Lists.concat(Stream.of(lists));
    }

    public static <C extends Collection<? extends T>, T> List<? extends T> concat(Stream<C> lists) {
        return lists.flatMap(Collection::stream).toList();
    }
}

