/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Locale;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Constants;
import org.wiremock.url.Host;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.Strings;

final class HostValue
implements Host {
    private final String host;
    private final MemoisedNormalisable<Host> normalisable;

    HostValue(String host) {
        this(host, null);
    }

    HostValue(String host, @Nullable Boolean isNormalForm) {
        this.host = host;
        this.normalisable = new MemoisedNormalisable<Host>(this, isNormalForm, this::doIsNormalForm, this::doNormalise);
    }

    public String toString() {
        return this.host;
    }

    @Override
    public Host normalise() {
        return this.normalisable.normalise();
    }

    private @Nullable Host doNormalise() {
        String normalised = Strings.transform(this.host, Constants.pctEncodedPattern, matched -> matched.toUpperCase(Locale.ROOT), unmatched -> unmatched.toLowerCase(Locale.ROOT));
        return normalised.equals(this.host) ? null : new HostValue(normalised, true);
    }

    @Override
    public boolean isNormalForm() {
        return this.normalisable.isNormalForm();
    }

    private boolean doIsNormalForm() {
        return this.normalise().equals(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Host) {
            Host that = (Host)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.host);
    }
}

