/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiremock.url.Constants;
import org.wiremock.url.Host;
import org.wiremock.url.HostValue;
import org.wiremock.url.IllegalHost;
import org.wiremock.url.PercentEncodedStringParser;
import org.wiremock.url.PercentEncoding;

public final class HostParser
implements PercentEncodedStringParser<Host> {
    public static final HostParser INSTANCE = new HostParser();
    static final String ipv6Address = "(?<ipv6Address>[0-9A-Fa-f:.]+)";
    static final String ipvFuture = "v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+";
    static final String ipLiteral = "\\[(?:(?<ipv6Address>[0-9A-Fa-f:.]+)|v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+)]";
    static final String registeredName = "(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*";
    static final String hostRegex = "\\[(?:(?<ipv6Address>[0-9A-Fa-f:.]+)|v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+)]|(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*";
    private final Pattern hostPattern = Pattern.compile("^\\[(?:(?<ipv6Address>[0-9A-Fa-f:.]+)|v[0-9A-Fa-f]\\.[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=:]+)]|(?:[-a-zA-Z0-9\\._~!\\$&'\\(\\)\\*\\+,;=]|%[0-9a-fA-F]{2})*$");
    private static final boolean[] hostCharSet = Constants.combine(Constants.unreservedCharSet, new boolean[][]{Constants.subDelimCharSet});

    public Class<Host> getType() {
        return Host.class;
    }

    public Host parse(String stringForm) throws IllegalHost {
        if (stringForm.isEmpty()) {
            return Host.EMPTY;
        }
        if (stringForm.equals("localhost")) {
            return Host.LOCALHOST;
        }
        Matcher matcher = this.hostPattern.matcher(stringForm);
        if (matcher.matches()) {
            String ipv6Address = matcher.group("ipv6Address");
            if (ipv6Address != null) {
                if (!ipv6Address.contains(":")) {
                    throw new IllegalHost(stringForm);
                }
                try {
                    InetAddress.getByName(ipv6Address);
                }
                catch (UnknownHostException e) {
                    throw new IllegalHost(stringForm);
                }
            }
            return new HostValue(stringForm);
        }
        throw new IllegalHost(stringForm);
    }

    @Override
    public Host encode(String unencoded) {
        if (unencoded.isEmpty()) {
            return Host.EMPTY;
        }
        if (unencoded.equals("localhost")) {
            return Host.LOCALHOST;
        }
        String result = PercentEncoding.encode(unencoded, hostCharSet);
        return new HostValue(result, true);
    }
}

