/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Authority;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPort;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;

final class HostAndPortValue
implements HostAndPort {
    private final Host host;
    private final @Nullable Port port;

    HostAndPortValue(Host host, @Nullable Port port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public String toString() {
        if (this.port != null) {
            return String.valueOf(this.host) + ":" + String.valueOf(this.port);
        }
        return this.host.toString();
    }

    @Override
    public @Nullable Optional<Port> getMaybePort() {
        return this.port != null ? Optional.of(this.port) : null;
    }

    @Override
    public HostAndPort withPort(@Nullable Port port) {
        if (Objects.equals(port, this.port)) {
            return this;
        }
        return HostAndPort.of(this.host, port);
    }

    @Override
    public HostAndPort normalise() {
        Host normalisedHost = this.host.normalise();
        Port normalisedPort = this.port == null ? null : this.port.normalise();
        return this.normalised(normalisedHost, normalisedPort);
    }

    @Override
    public HostAndPort normalise(Scheme canonicalScheme) {
        Port normalisedPort;
        Host normalisedHost = this.host.normalise();
        Port port = normalisedPort = this.port == null ? null : this.port.normalise();
        if (Objects.equals(canonicalScheme.getDefaultPort(), normalisedPort)) {
            normalisedPort = null;
        }
        return this.normalised(normalisedHost, normalisedPort);
    }

    private HostAndPort normalised(Host normalisedHost, @Nullable Port normalisedPort) {
        return normalisedHost.equals(this.host) && Objects.equals(normalisedPort, this.port) ? this : HostAndPort.of(normalisedHost, normalisedPort);
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public @Nullable Port getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        return Authority.equals(this, other);
    }

    public int hashCode() {
        return Authority.hashCode(this);
    }
}

