/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import org.jspecify.annotations.Nullable;
import org.wiremock.url.Authority;
import org.wiremock.url.Host;
import org.wiremock.url.HostAndPortParser;
import org.wiremock.url.HostAndPortValue;
import org.wiremock.url.IllegalAuthority;
import org.wiremock.url.Port;
import org.wiremock.url.Scheme;
import org.wiremock.url.UserInfo;

public interface HostAndPort
extends Authority {
    public static final HostAndPort EMPTY = new HostAndPortValue(Host.EMPTY, null);

    public static HostAndPort of(Host host) {
        return HostAndPort.of(host, null);
    }

    public static HostAndPort of(Host host, @Nullable Port port) {
        if (host.isEmpty() && port == null) {
            return EMPTY;
        }
        return new HostAndPortValue(host, port);
    }

    public static HostAndPort parse(String hostAndPortStr) throws IllegalAuthority {
        return HostAndPortParser.INSTANCE.parse(hostAndPortStr);
    }

    @Override
    @Deprecated
    default public @Nullable UserInfo getUserInfo() {
        return null;
    }

    @Override
    @Deprecated
    default public HostAndPort getHostAndPort() {
        return this;
    }

    @Override
    public HostAndPort withPort(@Nullable Port var1);

    @Override
    public HostAndPort normalise();

    @Override
    public HostAndPort normalise(Scheme var1);
}

