/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.wiremock.url.CodePoint;
import org.wiremock.url.HexCharacter;
import org.wiremock.url.HexCodePoint;

final class HexSequence
implements HexCodePoint {
    private final HexCharacter[] hexChars;

    HexSequence(HexCharacter[] hexChars) {
        this.hexChars = hexChars;
        if (hexChars.length == 0 || hexChars.length > 4) {
            throw new IllegalArgumentException("hex sequence must be 1-4 hex characters, was " + Arrays.toString(hexChars));
        }
    }

    @Override
    public CodePoint decode() {
        byte[] bytes = new byte[this.hexChars.length];
        for (int i = 0; i < this.hexChars.length; ++i) {
            HexCharacter hc = this.hexChars[i];
            bytes[i] = (byte)(HexCodePoint.hexDigitToInt(hc.digit1()) << 4 | HexCodePoint.hexDigitToInt(hc.digit2()));
        }
        String decoded = new String(bytes, StandardCharsets.UTF_8);
        int codePoint = decoded.codePointAt(0);
        return new CodePoint(codePoint);
    }

    @Override
    public HexSequence toUpperCase() {
        HexCharacter[] upper = new HexCharacter[this.hexChars.length];
        boolean changed = false;
        for (int i = 0; i < this.hexChars.length; ++i) {
            HexCharacter original = this.hexChars[i];
            HexCharacter upperCase = original.toUpperCase();
            if (!upperCase.equals(original)) {
                changed = true;
            }
            upper[i] = upperCase;
        }
        if (changed) {
            return new HexSequence(upper);
        }
        return this;
    }

    @Override
    public boolean isUpperCase() {
        for (HexCharacter hexChar : this.hexChars) {
            if (hexChar.isUpperCase()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HexCharacter hexChar : this.hexChars) {
            sb.append(hexChar);
        }
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder builder) {
        for (HexCharacter hexChar : this.hexChars) {
            hexChar.appendTo(builder);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HexSequence)) {
            return false;
        }
        HexSequence that = (HexSequence)obj;
        return Arrays.equals(this.hexChars, that.hexChars);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hexChars);
    }
}

