/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.url;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.wiremock.url.Fragment;
import org.wiremock.url.FragmentParser;
import org.wiremock.url.MemoisedNormalisable;
import org.wiremock.url.PercentEncoding;

final class FragmentValue
implements Fragment {
    private final String fragment;
    private final MemoisedNormalisable<Fragment> memoisedNormalisable;

    FragmentValue(String fragment) {
        this(fragment, null);
    }

    FragmentValue(String fragment, @Nullable Boolean isNormalForm) {
        this.fragment = fragment;
        this.memoisedNormalisable = new MemoisedNormalisable<Fragment>(this, isNormalForm, this::isNormalFormWork, this::normaliseWork);
    }

    public String toString() {
        return this.fragment;
    }

    @Override
    public Fragment normalise() {
        return this.memoisedNormalisable.normalise();
    }

    private @Nullable Fragment normaliseWork() {
        String result = PercentEncoding.simpleNormalise(this.fragment, FragmentParser.fragmentCharSet);
        return result != null ? new FragmentValue(result, true) : null;
    }

    @Override
    public boolean isNormalForm() {
        return this.memoisedNormalisable.isNormalForm();
    }

    private boolean isNormalFormWork() {
        return PercentEncoding.isSimpleNormalForm(this.fragment, FragmentParser.fragmentCharSet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Fragment) {
            Fragment that = (Fragment)obj;
            return Objects.equals(this.toString(), that.toString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fragment);
    }
}

